package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  AssociationId,
  ApplyOnlyAtCronInterval,
  ParameterName,
  ParameterValue,
  DocumentARN,
  ScheduleExpression,
  InstanceId,
  AssociationName,
  DocumentVersion,
  DateTime,
  AssociationVersion,
  CalendarNameOrARN,
  AutomationTargetParameterName,
  MaxConcurrency,
  MaxErrors
}
import scala.jdk.CollectionConverters._
final case class AssociationDescription(
    name: Optional[DocumentARN] = Optional.Absent,
    instanceId: Optional[InstanceId] = Optional.Absent,
    associationVersion: Optional[AssociationVersion] = Optional.Absent,
    date: Optional[DateTime] = Optional.Absent,
    lastUpdateAssociationDate: Optional[DateTime] = Optional.Absent,
    status: Optional[zio.aws.ssm.model.AssociationStatus] = Optional.Absent,
    overview: Optional[zio.aws.ssm.model.AssociationOverview] = Optional.Absent,
    documentVersion: Optional[DocumentVersion] = Optional.Absent,
    automationTargetParameterName: Optional[AutomationTargetParameterName] =
      Optional.Absent,
    parameters: Optional[Map[ParameterName, Iterable[ParameterValue]]] =
      Optional.Absent,
    associationId: Optional[AssociationId] = Optional.Absent,
    targets: Optional[Iterable[zio.aws.ssm.model.Target]] = Optional.Absent,
    scheduleExpression: Optional[ScheduleExpression] = Optional.Absent,
    outputLocation: Optional[
      zio.aws.ssm.model.InstanceAssociationOutputLocation
    ] = Optional.Absent,
    lastExecutionDate: Optional[DateTime] = Optional.Absent,
    lastSuccessfulExecutionDate: Optional[DateTime] = Optional.Absent,
    associationName: Optional[AssociationName] = Optional.Absent,
    maxErrors: Optional[MaxErrors] = Optional.Absent,
    maxConcurrency: Optional[MaxConcurrency] = Optional.Absent,
    complianceSeverity: Optional[
      zio.aws.ssm.model.AssociationComplianceSeverity
    ] = Optional.Absent,
    syncCompliance: Optional[zio.aws.ssm.model.AssociationSyncCompliance] =
      Optional.Absent,
    applyOnlyAtCronInterval: Optional[ApplyOnlyAtCronInterval] =
      Optional.Absent,
    calendarNames: Optional[Iterable[CalendarNameOrARN]] = Optional.Absent,
    targetLocations: Optional[Iterable[zio.aws.ssm.model.TargetLocation]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AssociationDescription = {
    import AssociationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AssociationDescription
      .builder()
      .optionallyWith(
        name.map(value => DocumentARN.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        associationVersion.map(value =>
          AssociationVersion.unwrap(value): java.lang.String
        )
      )(_.associationVersion)
      .optionallyWith(date.map(value => DateTime.unwrap(value): Instant))(
        _.date
      )
      .optionallyWith(
        lastUpdateAssociationDate.map(value => DateTime.unwrap(value): Instant)
      )(_.lastUpdateAssociationDate)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(overview.map(value => value.buildAwsValue()))(_.overview)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        automationTargetParameterName.map(value =>
          AutomationTargetParameterName.unwrap(value): java.lang.String
        )
      )(_.automationTargetParameterName)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterName.unwrap(key): java.lang.String) -> value.map {
                item =>
                  ParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        associationId.map(value =>
          AssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        scheduleExpression.map(value =>
          ScheduleExpression.unwrap(value): java.lang.String
        )
      )(_.scheduleExpression)
      .optionallyWith(outputLocation.map(value => value.buildAwsValue()))(
        _.outputLocation
      )
      .optionallyWith(
        lastExecutionDate.map(value => DateTime.unwrap(value): Instant)
      )(_.lastExecutionDate)
      .optionallyWith(
        lastSuccessfulExecutionDate.map(value =>
          DateTime.unwrap(value): Instant
        )
      )(_.lastSuccessfulExecutionDate)
      .optionallyWith(
        associationName.map(value =>
          AssociationName.unwrap(value): java.lang.String
        )
      )(_.associationName)
      .optionallyWith(
        maxErrors.map(value => MaxErrors.unwrap(value): java.lang.String)
      )(_.maxErrors)
      .optionallyWith(
        maxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.maxConcurrency)
      .optionallyWith(complianceSeverity.map(value => value.unwrap))(
        _.complianceSeverity
      )
      .optionallyWith(syncCompliance.map(value => value.unwrap))(
        _.syncCompliance
      )
      .optionallyWith(
        applyOnlyAtCronInterval.map(value =>
          ApplyOnlyAtCronInterval.unwrap(value): java.lang.Boolean
        )
      )(_.applyOnlyAtCronInterval)
      .optionallyWith(
        calendarNames.map(value =>
          value.map { item =>
            CalendarNameOrARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.calendarNames)
      .optionallyWith(
        targetLocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetLocations)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AssociationDescription.ReadOnly =
    zio.aws.ssm.model.AssociationDescription.wrap(buildAwsValue())
}
object AssociationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AssociationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AssociationDescription =
      zio.aws.ssm.model.AssociationDescription(
        name.map(value => value),
        instanceId.map(value => value),
        associationVersion.map(value => value),
        date.map(value => value),
        lastUpdateAssociationDate.map(value => value),
        status.map(value => value.asEditable),
        overview.map(value => value.asEditable),
        documentVersion.map(value => value),
        automationTargetParameterName.map(value => value),
        parameters.map(value => value),
        associationId.map(value => value),
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scheduleExpression.map(value => value),
        outputLocation.map(value => value.asEditable),
        lastExecutionDate.map(value => value),
        lastSuccessfulExecutionDate.map(value => value),
        associationName.map(value => value),
        maxErrors.map(value => value),
        maxConcurrency.map(value => value),
        complianceSeverity.map(value => value),
        syncCompliance.map(value => value),
        applyOnlyAtCronInterval.map(value => value),
        calendarNames.map(value => value),
        targetLocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Optional[DocumentARN]
    def instanceId: Optional[InstanceId]
    def associationVersion: Optional[AssociationVersion]
    def date: Optional[DateTime]
    def lastUpdateAssociationDate: Optional[DateTime]
    def status: Optional[zio.aws.ssm.model.AssociationStatus.ReadOnly]
    def overview: Optional[zio.aws.ssm.model.AssociationOverview.ReadOnly]
    def documentVersion: Optional[DocumentVersion]
    def automationTargetParameterName: Optional[AutomationTargetParameterName]
    def parameters: Optional[Map[ParameterName, List[ParameterValue]]]
    def associationId: Optional[AssociationId]
    def targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]]
    def scheduleExpression: Optional[ScheduleExpression]
    def outputLocation
        : Optional[zio.aws.ssm.model.InstanceAssociationOutputLocation.ReadOnly]
    def lastExecutionDate: Optional[DateTime]
    def lastSuccessfulExecutionDate: Optional[DateTime]
    def associationName: Optional[AssociationName]
    def maxErrors: Optional[MaxErrors]
    def maxConcurrency: Optional[MaxConcurrency]
    def complianceSeverity
        : Optional[zio.aws.ssm.model.AssociationComplianceSeverity]
    def syncCompliance: Optional[zio.aws.ssm.model.AssociationSyncCompliance]
    def applyOnlyAtCronInterval: Optional[ApplyOnlyAtCronInterval]
    def calendarNames: Optional[List[CalendarNameOrARN]]
    def targetLocations
        : Optional[List[zio.aws.ssm.model.TargetLocation.ReadOnly]]
    def getName: ZIO[Any, AwsError, DocumentARN] =
      AwsError.unwrapOptionField("name", name)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getAssociationVersion: ZIO[Any, AwsError, AssociationVersion] =
      AwsError.unwrapOptionField("associationVersion", associationVersion)
    def getDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("date", date)
    def getLastUpdateAssociationDate: ZIO[Any, AwsError, DateTime] = AwsError
      .unwrapOptionField("lastUpdateAssociationDate", lastUpdateAssociationDate)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ssm.model.AssociationStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getOverview
        : ZIO[Any, AwsError, zio.aws.ssm.model.AssociationOverview.ReadOnly] =
      AwsError.unwrapOptionField("overview", overview)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getAutomationTargetParameterName
        : ZIO[Any, AwsError, AutomationTargetParameterName] =
      AwsError.unwrapOptionField(
        "automationTargetParameterName",
        automationTargetParameterName
      )
    def getParameters
        : ZIO[Any, AwsError, Map[ParameterName, List[ParameterValue]]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getAssociationId: ZIO[Any, AwsError, AssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getScheduleExpression: ZIO[Any, AwsError, ScheduleExpression] =
      AwsError.unwrapOptionField("scheduleExpression", scheduleExpression)
    def getOutputLocation: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.InstanceAssociationOutputLocation.ReadOnly
    ] = AwsError.unwrapOptionField("outputLocation", outputLocation)
    def getLastExecutionDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastExecutionDate", lastExecutionDate)
    def getLastSuccessfulExecutionDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField(
        "lastSuccessfulExecutionDate",
        lastSuccessfulExecutionDate
      )
    def getAssociationName: ZIO[Any, AwsError, AssociationName] =
      AwsError.unwrapOptionField("associationName", associationName)
    def getMaxErrors: ZIO[Any, AwsError, MaxErrors] =
      AwsError.unwrapOptionField("maxErrors", maxErrors)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getComplianceSeverity
        : ZIO[Any, AwsError, zio.aws.ssm.model.AssociationComplianceSeverity] =
      AwsError.unwrapOptionField("complianceSeverity", complianceSeverity)
    def getSyncCompliance
        : ZIO[Any, AwsError, zio.aws.ssm.model.AssociationSyncCompliance] =
      AwsError.unwrapOptionField("syncCompliance", syncCompliance)
    def getApplyOnlyAtCronInterval
        : ZIO[Any, AwsError, ApplyOnlyAtCronInterval] = AwsError
      .unwrapOptionField("applyOnlyAtCronInterval", applyOnlyAtCronInterval)
    def getCalendarNames: ZIO[Any, AwsError, List[CalendarNameOrARN]] =
      AwsError.unwrapOptionField("calendarNames", calendarNames)
    def getTargetLocations
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.TargetLocation.ReadOnly]] =
      AwsError.unwrapOptionField("targetLocations", targetLocations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AssociationDescription
  ) extends zio.aws.ssm.model.AssociationDescription.ReadOnly {
    override val name: Optional[DocumentARN] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssm.model.primitives.DocumentARN(value))
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.ssm.model.primitives.InstanceId(value))
    override val associationVersion: Optional[AssociationVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationVersion())
        .map(value => zio.aws.ssm.model.primitives.AssociationVersion(value))
    override val date: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.date())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val lastUpdateAssociationDate: Optional[DateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdateAssociationDate())
        .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val status
        : Optional[zio.aws.ssm.model.AssociationStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssm.model.AssociationStatus.wrap(value))
    override val overview
        : Optional[zio.aws.ssm.model.AssociationOverview.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overview())
        .map(value => zio.aws.ssm.model.AssociationOverview.wrap(value))
    override val documentVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val automationTargetParameterName
        : Optional[AutomationTargetParameterName] = zio.aws.core.internal
      .optionalFromNullable(impl.automationTargetParameterName())
      .map(value =>
        zio.aws.ssm.model.primitives.AutomationTargetParameterName(value)
      )
    override val parameters
        : Optional[Map[ParameterName, List[ParameterValue]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .ParameterName(key) -> value.asScala.map { item =>
                zio.aws.ssm.model.primitives.ParameterValue(item)
              }.toList
            })
            .toMap
        )
    override val associationId: Optional[AssociationId] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => zio.aws.ssm.model.primitives.AssociationId(value))
    override val targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val scheduleExpression: Optional[ScheduleExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleExpression())
        .map(value => zio.aws.ssm.model.primitives.ScheduleExpression(value))
    override val outputLocation: Optional[
      zio.aws.ssm.model.InstanceAssociationOutputLocation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputLocation())
      .map(value =>
        zio.aws.ssm.model.InstanceAssociationOutputLocation.wrap(value)
      )
    override val lastExecutionDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastExecutionDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val lastSuccessfulExecutionDate: Optional[DateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSuccessfulExecutionDate())
        .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val associationName: Optional[AssociationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationName())
        .map(value => zio.aws.ssm.model.primitives.AssociationName(value))
    override val maxErrors: Optional[MaxErrors] = zio.aws.core.internal
      .optionalFromNullable(impl.maxErrors())
      .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
    override val maxConcurrency: Optional[MaxConcurrency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConcurrency())
        .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val complianceSeverity
        : Optional[zio.aws.ssm.model.AssociationComplianceSeverity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceSeverity())
        .map(value =>
          zio.aws.ssm.model.AssociationComplianceSeverity.wrap(value)
        )
    override val syncCompliance
        : Optional[zio.aws.ssm.model.AssociationSyncCompliance] =
      zio.aws.core.internal
        .optionalFromNullable(impl.syncCompliance())
        .map(value => zio.aws.ssm.model.AssociationSyncCompliance.wrap(value))
    override val applyOnlyAtCronInterval: Optional[ApplyOnlyAtCronInterval] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applyOnlyAtCronInterval())
        .map(value =>
          zio.aws.ssm.model.primitives.ApplyOnlyAtCronInterval(value)
        )
    override val calendarNames: Optional[List[CalendarNameOrARN]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.calendarNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.CalendarNameOrARN(item)
          }.toList
        )
    override val targetLocations
        : Optional[List[zio.aws.ssm.model.TargetLocation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetLocations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.TargetLocation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AssociationDescription
  ): zio.aws.ssm.model.AssociationDescription.ReadOnly = new Wrapper(impl)
}
