package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowTaskParameterName,
  MaintenanceWindowTaskPriority,
  MaintenanceWindowId,
  MaintenanceWindowTaskArn,
  MaintenanceWindowTaskId,
  ServiceRole,
  MaxConcurrency,
  MaintenanceWindowName,
  MaxErrors,
  MaintenanceWindowDescription
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateMaintenanceWindowTaskRequest(
    windowId: MaintenanceWindowId,
    windowTaskId: MaintenanceWindowTaskId,
    targets: Option[Iterable[zio.aws.ssm.model.Target]] = None,
    taskArn: Option[MaintenanceWindowTaskArn] = None,
    serviceRoleArn: Option[ServiceRole] = None,
    taskParameters: Option[Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression
    ]] = None,
    taskInvocationParameters: Option[
      zio.aws.ssm.model.MaintenanceWindowTaskInvocationParameters
    ] = None,
    priority: Option[MaintenanceWindowTaskPriority] = None,
    maxConcurrency: Option[MaxConcurrency] = None,
    maxErrors: Option[MaxErrors] = None,
    loggingInfo: Option[zio.aws.ssm.model.LoggingInfo] = None,
    name: Option[MaintenanceWindowName] = None,
    description: Option[MaintenanceWindowDescription] = None,
    replace: Option[Boolean] = None,
    cutoffBehavior: Option[
      zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskRequest = {
    import UpdateMaintenanceWindowTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskRequest
      .builder()
      .windowId(MaintenanceWindowId.unwrap(windowId): java.lang.String)
      .windowTaskId(
        MaintenanceWindowTaskId.unwrap(windowTaskId): java.lang.String
      )
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        taskArn.map(value =>
          MaintenanceWindowTaskArn.unwrap(value): java.lang.String
        )
      )(_.taskArn)
      .optionallyWith(
        serviceRoleArn.map(value => ServiceRole.unwrap(value): java.lang.String)
      )(_.serviceRoleArn)
      .optionallyWith(
        taskParameters.map(value =>
          value
            .map({ case (key, value) =>
              (MaintenanceWindowTaskParameterName.unwrap(
                key
              ): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.taskParameters)
      .optionallyWith(
        taskInvocationParameters.map(value => value.buildAwsValue())
      )(_.taskInvocationParameters)
      .optionallyWith(
        priority.map(value =>
          MaintenanceWindowTaskPriority.unwrap(value): Integer
        )
      )(_.priority)
      .optionallyWith(
        maxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.maxConcurrency)
      .optionallyWith(
        maxErrors.map(value => MaxErrors.unwrap(value): java.lang.String)
      )(_.maxErrors)
      .optionallyWith(loggingInfo.map(value => value.buildAwsValue()))(
        _.loggingInfo
      )
      .optionallyWith(
        name.map(value => MaintenanceWindowName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          MaintenanceWindowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(replace.map(value => value: java.lang.Boolean))(_.replace)
      .optionallyWith(cutoffBehavior.map(value => value.unwrap))(
        _.cutoffBehavior
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.UpdateMaintenanceWindowTaskRequest.ReadOnly =
    zio.aws.ssm.model.UpdateMaintenanceWindowTaskRequest.wrap(buildAwsValue())
}
object UpdateMaintenanceWindowTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateMaintenanceWindowTaskRequest =
      zio.aws.ssm.model.UpdateMaintenanceWindowTaskRequest(
        windowId,
        windowTaskId,
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        taskArn.map(value => value),
        serviceRoleArn.map(value => value),
        taskParameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        taskInvocationParameters.map(value => value.asEditable),
        priority.map(value => value),
        maxConcurrency.map(value => value),
        maxErrors.map(value => value),
        loggingInfo.map(value => value.asEditable),
        name.map(value => value),
        description.map(value => value),
        replace.map(value => value),
        cutoffBehavior.map(value => value)
      )
    def windowId: MaintenanceWindowId
    def windowTaskId: MaintenanceWindowTaskId
    def targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]]
    def taskArn: Option[MaintenanceWindowTaskArn]
    def serviceRoleArn: Option[ServiceRole]
    def taskParameters: Option[Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression.ReadOnly
    ]]
    def taskInvocationParameters: Option[
      zio.aws.ssm.model.MaintenanceWindowTaskInvocationParameters.ReadOnly
    ]
    def priority: Option[MaintenanceWindowTaskPriority]
    def maxConcurrency: Option[MaxConcurrency]
    def maxErrors: Option[MaxErrors]
    def loggingInfo: Option[zio.aws.ssm.model.LoggingInfo.ReadOnly]
    def name: Option[MaintenanceWindowName]
    def description: Option[MaintenanceWindowDescription]
    def replace: Option[Boolean]
    def cutoffBehavior
        : Option[zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior]
    def getWindowId: ZIO[Any, Nothing, MaintenanceWindowId] =
      ZIO.succeed(windowId)
    def getWindowTaskId: ZIO[Any, Nothing, MaintenanceWindowTaskId] =
      ZIO.succeed(windowTaskId)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getTaskArn: ZIO[Any, AwsError, MaintenanceWindowTaskArn] =
      AwsError.unwrapOptionField("taskArn", taskArn)
    def getServiceRoleArn: ZIO[Any, AwsError, ServiceRole] =
      AwsError.unwrapOptionField("serviceRoleArn", serviceRoleArn)
    def getTaskParameters: ZIO[Any, AwsError, Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression.ReadOnly
    ]] = AwsError.unwrapOptionField("taskParameters", taskParameters)
    def getTaskInvocationParameters: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowTaskInvocationParameters.ReadOnly
    ] = AwsError.unwrapOptionField(
      "taskInvocationParameters",
      taskInvocationParameters
    )
    def getPriority: ZIO[Any, AwsError, MaintenanceWindowTaskPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getMaxErrors: ZIO[Any, AwsError, MaxErrors] =
      AwsError.unwrapOptionField("maxErrors", maxErrors)
    def getLoggingInfo
        : ZIO[Any, AwsError, zio.aws.ssm.model.LoggingInfo.ReadOnly] =
      AwsError.unwrapOptionField("loggingInfo", loggingInfo)
    def getName: ZIO[Any, AwsError, MaintenanceWindowName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, MaintenanceWindowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getReplace: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("replace", replace)
    def getCutoffBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior
    ] = AwsError.unwrapOptionField("cutoffBehavior", cutoffBehavior)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskRequest
  ) extends zio.aws.ssm.model.UpdateMaintenanceWindowTaskRequest.ReadOnly {
    override val windowId: MaintenanceWindowId =
      zio.aws.ssm.model.primitives.MaintenanceWindowId(impl.windowId())
    override val windowTaskId: MaintenanceWindowTaskId =
      zio.aws.ssm.model.primitives.MaintenanceWindowTaskId(impl.windowTaskId())
    override val targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]] =
      scala
        .Option(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val taskArn: Option[MaintenanceWindowTaskArn] = scala
      .Option(impl.taskArn())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowTaskArn(value)
      )
    override val serviceRoleArn: Option[ServiceRole] = scala
      .Option(impl.serviceRoleArn())
      .map(value => zio.aws.ssm.model.primitives.ServiceRole(value))
    override val taskParameters: Option[Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression.ReadOnly
    ]] = scala
      .Option(impl.taskParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives.MaintenanceWindowTaskParameterName(
              key
            ) -> zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression
              .wrap(value)
          })
          .toMap
      )
    override val taskInvocationParameters: Option[
      zio.aws.ssm.model.MaintenanceWindowTaskInvocationParameters.ReadOnly
    ] = scala
      .Option(impl.taskInvocationParameters())
      .map(value =>
        zio.aws.ssm.model.MaintenanceWindowTaskInvocationParameters.wrap(value)
      )
    override val priority: Option[MaintenanceWindowTaskPriority] = scala
      .Option(impl.priority())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowTaskPriority(value)
      )
    override val maxConcurrency: Option[MaxConcurrency] = scala
      .Option(impl.maxConcurrency())
      .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val maxErrors: Option[MaxErrors] = scala
      .Option(impl.maxErrors())
      .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
    override val loggingInfo: Option[zio.aws.ssm.model.LoggingInfo.ReadOnly] =
      scala
        .Option(impl.loggingInfo())
        .map(value => zio.aws.ssm.model.LoggingInfo.wrap(value))
    override val name: Option[MaintenanceWindowName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowName(value))
    override val description: Option[MaintenanceWindowDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowDescription(value)
      )
    override val replace: Option[Boolean] =
      scala.Option(impl.replace()).map(value => value: Boolean)
    override val cutoffBehavior
        : Option[zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior] = scala
      .Option(impl.cutoffBehavior())
      .map(value =>
        zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskRequest
  ): zio.aws.ssm.model.UpdateMaintenanceWindowTaskRequest.ReadOnly =
    new Wrapper(impl)
}
