package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  AutomationParameterValue,
  AutomationParameterKey,
  AutomationExecutionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SendAutomationSignalRequest(
    automationExecutionId: AutomationExecutionId,
    signalType: zio.aws.ssm.model.SignalType,
    payload: Option[
      Map[AutomationParameterKey, Iterable[AutomationParameterValue]]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.SendAutomationSignalRequest = {
    import SendAutomationSignalRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.SendAutomationSignalRequest
      .builder()
      .automationExecutionId(
        AutomationExecutionId.unwrap(automationExecutionId): java.lang.String
      )
      .signalType(signalType.unwrap)
      .optionallyWith(
        payload.map(value =>
          value
            .map({ case (key, value) =>
              (AutomationParameterKey
                .unwrap(key): java.lang.String) -> value.map { item =>
                AutomationParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.payload)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.SendAutomationSignalRequest.ReadOnly =
    zio.aws.ssm.model.SendAutomationSignalRequest.wrap(buildAwsValue())
}
object SendAutomationSignalRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.SendAutomationSignalRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.SendAutomationSignalRequest =
      zio.aws.ssm.model.SendAutomationSignalRequest(
        automationExecutionId,
        signalType,
        payload.map(value => value)
      )
    def automationExecutionId: AutomationExecutionId
    def signalType: zio.aws.ssm.model.SignalType
    def payload
        : Option[Map[AutomationParameterKey, List[AutomationParameterValue]]]
    def getAutomationExecutionId: ZIO[Any, Nothing, AutomationExecutionId] =
      ZIO.succeed(automationExecutionId)
    def getSignalType: ZIO[Any, Nothing, zio.aws.ssm.model.SignalType] =
      ZIO.succeed(signalType)
    def getPayload: ZIO[Any, AwsError, Map[AutomationParameterKey, List[
      AutomationParameterValue
    ]]] = AwsError.unwrapOptionField("payload", payload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.SendAutomationSignalRequest
  ) extends zio.aws.ssm.model.SendAutomationSignalRequest.ReadOnly {
    override val automationExecutionId: AutomationExecutionId =
      zio.aws.ssm.model.primitives
        .AutomationExecutionId(impl.automationExecutionId())
    override val signalType: zio.aws.ssm.model.SignalType =
      zio.aws.ssm.model.SignalType.wrap(impl.signalType())
    override val payload
        : Option[Map[AutomationParameterKey, List[AutomationParameterValue]]] =
      scala
        .Option(impl.payload())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .AutomationParameterKey(key) -> value.asScala.map { item =>
                zio.aws.ssm.model.primitives.AutomationParameterValue(item)
              }.toList
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.SendAutomationSignalRequest
  ): zio.aws.ssm.model.SendAutomationSignalRequest.ReadOnly = new Wrapper(impl)
}
