package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  PSParameterName,
  PSParameterVersion,
  PSParameterSelector,
  DateTime,
  PSParameterValue,
  ParameterDataType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Parameter(
    name: Option[PSParameterName] = None,
    `type`: Option[zio.aws.ssm.model.ParameterType] = None,
    value: Option[PSParameterValue] = None,
    version: Option[PSParameterVersion] = None,
    selector: Option[PSParameterSelector] = None,
    sourceResult: Option[String] = None,
    lastModifiedDate: Option[DateTime] = None,
    arn: Option[String] = None,
    dataType: Option[ParameterDataType] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.Parameter = {
    import Parameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.Parameter
      .builder()
      .optionallyWith(
        name.map(value => PSParameterName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        value.map(value => PSParameterValue.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(
        version.map(value => PSParameterVersion.unwrap(value): java.lang.Long)
      )(_.version)
      .optionallyWith(
        selector.map(value =>
          PSParameterSelector.unwrap(value): java.lang.String
        )
      )(_.selector)
      .optionallyWith(sourceResult.map(value => value: java.lang.String))(
        _.sourceResult
      )
      .optionallyWith(
        lastModifiedDate.map(value => DateTime.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        dataType.map(value => ParameterDataType.unwrap(value): java.lang.String)
      )(_.dataType)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.Parameter.ReadOnly =
    zio.aws.ssm.model.Parameter.wrap(buildAwsValue())
}
object Parameter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.Parameter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.Parameter = zio.aws.ssm.model.Parameter(
      name.map(value => value),
      `type`.map(value => value),
      value.map(value => value),
      version.map(value => value),
      selector.map(value => value),
      sourceResult.map(value => value),
      lastModifiedDate.map(value => value),
      arn.map(value => value),
      dataType.map(value => value)
    )
    def name: Option[PSParameterName]
    def `type`: Option[zio.aws.ssm.model.ParameterType]
    def value: Option[PSParameterValue]
    def version: Option[PSParameterVersion]
    def selector: Option[PSParameterSelector]
    def sourceResult: Option[String]
    def lastModifiedDate: Option[DateTime]
    def arn: Option[String]
    def dataType: Option[ParameterDataType]
    def getName: ZIO[Any, AwsError, PSParameterName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.ssm.model.ParameterType] =
      AwsError.unwrapOptionField("type", `type`)
    def getValue: ZIO[Any, AwsError, PSParameterValue] =
      AwsError.unwrapOptionField("value", value)
    def getVersion: ZIO[Any, AwsError, PSParameterVersion] =
      AwsError.unwrapOptionField("version", version)
    def getSelector: ZIO[Any, AwsError, PSParameterSelector] =
      AwsError.unwrapOptionField("selector", selector)
    def getSourceResult: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceResult", sourceResult)
    def getLastModifiedDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getDataType: ZIO[Any, AwsError, ParameterDataType] =
      AwsError.unwrapOptionField("dataType", dataType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.Parameter
  ) extends zio.aws.ssm.model.Parameter.ReadOnly {
    override val name: Option[PSParameterName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.PSParameterName(value))
    override val `type`: Option[zio.aws.ssm.model.ParameterType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.ssm.model.ParameterType.wrap(value))
    override val value: Option[PSParameterValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.ssm.model.primitives.PSParameterValue(value))
    override val version: Option[PSParameterVersion] = scala
      .Option(impl.version())
      .map(value => zio.aws.ssm.model.primitives.PSParameterVersion(value))
    override val selector: Option[PSParameterSelector] = scala
      .Option(impl.selector())
      .map(value => zio.aws.ssm.model.primitives.PSParameterSelector(value))
    override val sourceResult: Option[String] =
      scala.Option(impl.sourceResult()).map(value => value: String)
    override val lastModifiedDate: Option[DateTime] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val dataType: Option[ParameterDataType] = scala
      .Option(impl.dataType())
      .map(value => zio.aws.ssm.model.primitives.ParameterDataType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.Parameter
  ): zio.aws.ssm.model.Parameter.ReadOnly = new Wrapper(impl)
}
