package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait OpsItemEventFilterKey {
  def unwrap: software.amazon.awssdk.services.ssm.model.OpsItemEventFilterKey
}
object OpsItemEventFilterKey {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.OpsItemEventFilterKey
  ): zio.aws.ssm.model.OpsItemEventFilterKey = value match {
    case software.amazon.awssdk.services.ssm.model.OpsItemEventFilterKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemEventFilterKey.OPS_ITEM_ID =>
      val r = OpsItemId
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.OpsItemEventFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemEventFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemEventFilterKey.UNKNOWN_TO_SDK_VERSION
  }
  case object OpsItemId extends zio.aws.ssm.model.OpsItemEventFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemEventFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemEventFilterKey.OPS_ITEM_ID
  }
}
