package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  DocumentDisplayName,
  DocumentARN,
  DocumentVersion,
  DateTime,
  DocumentContent,
  DocumentStatusInformation,
  DocumentVersionName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetDocumentResponse(
    name: Option[DocumentARN] = None,
    createdDate: Option[DateTime] = None,
    displayName: Option[DocumentDisplayName] = None,
    versionName: Option[DocumentVersionName] = None,
    documentVersion: Option[DocumentVersion] = None,
    status: Option[zio.aws.ssm.model.DocumentStatus] = None,
    statusInformation: Option[DocumentStatusInformation] = None,
    content: Option[DocumentContent] = None,
    documentType: Option[zio.aws.ssm.model.DocumentType] = None,
    documentFormat: Option[zio.aws.ssm.model.DocumentFormat] = None,
    requires: Option[Iterable[zio.aws.ssm.model.DocumentRequires]] = None,
    attachmentsContent: Option[Iterable[zio.aws.ssm.model.AttachmentContent]] =
      None,
    reviewStatus: Option[zio.aws.ssm.model.ReviewStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetDocumentResponse = {
    import GetDocumentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetDocumentResponse
      .builder()
      .optionallyWith(
        name.map(value => DocumentARN.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        createdDate.map(value => DateTime.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        displayName.map(value =>
          DocumentDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        versionName.map(value =>
          DocumentVersionName.unwrap(value): java.lang.String
        )
      )(_.versionName)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusInformation.map(value =>
          DocumentStatusInformation.unwrap(value): java.lang.String
        )
      )(_.statusInformation)
      .optionallyWith(
        content.map(value => DocumentContent.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(documentType.map(value => value.unwrap))(_.documentType)
      .optionallyWith(documentFormat.map(value => value.unwrap))(
        _.documentFormat
      )
      .optionallyWith(
        requires.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.requires)
      .optionallyWith(
        attachmentsContent.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachmentsContent)
      .optionallyWith(reviewStatus.map(value => value.unwrap))(_.reviewStatus)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetDocumentResponse.ReadOnly =
    zio.aws.ssm.model.GetDocumentResponse.wrap(buildAwsValue())
}
object GetDocumentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetDocumentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetDocumentResponse =
      zio.aws.ssm.model.GetDocumentResponse(
        name.map(value => value),
        createdDate.map(value => value),
        displayName.map(value => value),
        versionName.map(value => value),
        documentVersion.map(value => value),
        status.map(value => value),
        statusInformation.map(value => value),
        content.map(value => value),
        documentType.map(value => value),
        documentFormat.map(value => value),
        requires.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        attachmentsContent.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reviewStatus.map(value => value)
      )
    def name: Option[DocumentARN]
    def createdDate: Option[DateTime]
    def displayName: Option[DocumentDisplayName]
    def versionName: Option[DocumentVersionName]
    def documentVersion: Option[DocumentVersion]
    def status: Option[zio.aws.ssm.model.DocumentStatus]
    def statusInformation: Option[DocumentStatusInformation]
    def content: Option[DocumentContent]
    def documentType: Option[zio.aws.ssm.model.DocumentType]
    def documentFormat: Option[zio.aws.ssm.model.DocumentFormat]
    def requires: Option[List[zio.aws.ssm.model.DocumentRequires.ReadOnly]]
    def attachmentsContent
        : Option[List[zio.aws.ssm.model.AttachmentContent.ReadOnly]]
    def reviewStatus: Option[zio.aws.ssm.model.ReviewStatus]
    def getName: ZIO[Any, AwsError, DocumentARN] =
      AwsError.unwrapOptionField("name", name)
    def getCreatedDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getDisplayName: ZIO[Any, AwsError, DocumentDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getVersionName: ZIO[Any, AwsError, DocumentVersionName] =
      AwsError.unwrapOptionField("versionName", versionName)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssm.model.DocumentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusInformation: ZIO[Any, AwsError, DocumentStatusInformation] =
      AwsError.unwrapOptionField("statusInformation", statusInformation)
    def getContent: ZIO[Any, AwsError, DocumentContent] =
      AwsError.unwrapOptionField("content", content)
    def getDocumentType: ZIO[Any, AwsError, zio.aws.ssm.model.DocumentType] =
      AwsError.unwrapOptionField("documentType", documentType)
    def getDocumentFormat
        : ZIO[Any, AwsError, zio.aws.ssm.model.DocumentFormat] =
      AwsError.unwrapOptionField("documentFormat", documentFormat)
    def getRequires: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.DocumentRequires.ReadOnly
    ]] = AwsError.unwrapOptionField("requires", requires)
    def getAttachmentsContent: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.AttachmentContent.ReadOnly
    ]] = AwsError.unwrapOptionField("attachmentsContent", attachmentsContent)
    def getReviewStatus: ZIO[Any, AwsError, zio.aws.ssm.model.ReviewStatus] =
      AwsError.unwrapOptionField("reviewStatus", reviewStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetDocumentResponse
  ) extends zio.aws.ssm.model.GetDocumentResponse.ReadOnly {
    override val name: Option[DocumentARN] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.DocumentARN(value))
    override val createdDate: Option[DateTime] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val displayName: Option[DocumentDisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.ssm.model.primitives.DocumentDisplayName(value))
    override val versionName: Option[DocumentVersionName] = scala
      .Option(impl.versionName())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersionName(value))
    override val documentVersion: Option[DocumentVersion] = scala
      .Option(impl.documentVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val status: Option[zio.aws.ssm.model.DocumentStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.ssm.model.DocumentStatus.wrap(value))
    override val statusInformation: Option[DocumentStatusInformation] = scala
      .Option(impl.statusInformation())
      .map(value =>
        zio.aws.ssm.model.primitives.DocumentStatusInformation(value)
      )
    override val content: Option[DocumentContent] = scala
      .Option(impl.content())
      .map(value => zio.aws.ssm.model.primitives.DocumentContent(value))
    override val documentType: Option[zio.aws.ssm.model.DocumentType] = scala
      .Option(impl.documentType())
      .map(value => zio.aws.ssm.model.DocumentType.wrap(value))
    override val documentFormat: Option[zio.aws.ssm.model.DocumentFormat] =
      scala
        .Option(impl.documentFormat())
        .map(value => zio.aws.ssm.model.DocumentFormat.wrap(value))
    override val requires
        : Option[List[zio.aws.ssm.model.DocumentRequires.ReadOnly]] = scala
      .Option(impl.requires())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.DocumentRequires.wrap(item)
        }.toList
      )
    override val attachmentsContent
        : Option[List[zio.aws.ssm.model.AttachmentContent.ReadOnly]] = scala
      .Option(impl.attachmentsContent())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.AttachmentContent.wrap(item)
        }.toList
      )
    override val reviewStatus: Option[zio.aws.ssm.model.ReviewStatus] = scala
      .Option(impl.reviewStatus())
      .map(value => zio.aws.ssm.model.ReviewStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetDocumentResponse
  ): zio.aws.ssm.model.GetDocumentResponse.ReadOnly = new Wrapper(impl)
}
