package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.InstancesCount
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribePatchGroupStateResponse(
    instances: Option[zio.aws.ssm.model.primitives.Integer] = None,
    instancesWithInstalledPatches: Option[
      zio.aws.ssm.model.primitives.Integer
    ] = None,
    instancesWithInstalledOtherPatches: Option[
      zio.aws.ssm.model.primitives.Integer
    ] = None,
    instancesWithInstalledPendingRebootPatches: Option[InstancesCount] = None,
    instancesWithInstalledRejectedPatches: Option[InstancesCount] = None,
    instancesWithMissingPatches: Option[zio.aws.ssm.model.primitives.Integer] =
      None,
    instancesWithFailedPatches: Option[zio.aws.ssm.model.primitives.Integer] =
      None,
    instancesWithNotApplicablePatches: Option[
      zio.aws.ssm.model.primitives.Integer
    ] = None,
    instancesWithUnreportedNotApplicablePatches: Option[
      zio.aws.ssm.model.primitives.Integer
    ] = None,
    instancesWithCriticalNonCompliantPatches: Option[InstancesCount] = None,
    instancesWithSecurityNonCompliantPatches: Option[InstancesCount] = None,
    instancesWithOtherNonCompliantPatches: Option[InstancesCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateResponse = {
    import DescribePatchGroupStateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateResponse
      .builder()
      .optionallyWith(instances.map(value => value: Integer))(_.instances)
      .optionallyWith(
        instancesWithInstalledPatches.map(value => value: Integer)
      )(_.instancesWithInstalledPatches)
      .optionallyWith(
        instancesWithInstalledOtherPatches.map(value => value: Integer)
      )(_.instancesWithInstalledOtherPatches)
      .optionallyWith(
        instancesWithInstalledPendingRebootPatches.map(value =>
          InstancesCount.unwrap(value): Integer
        )
      )(_.instancesWithInstalledPendingRebootPatches)
      .optionallyWith(
        instancesWithInstalledRejectedPatches.map(value =>
          InstancesCount.unwrap(value): Integer
        )
      )(_.instancesWithInstalledRejectedPatches)
      .optionallyWith(instancesWithMissingPatches.map(value => value: Integer))(
        _.instancesWithMissingPatches
      )
      .optionallyWith(instancesWithFailedPatches.map(value => value: Integer))(
        _.instancesWithFailedPatches
      )
      .optionallyWith(
        instancesWithNotApplicablePatches.map(value => value: Integer)
      )(_.instancesWithNotApplicablePatches)
      .optionallyWith(
        instancesWithUnreportedNotApplicablePatches.map(value => value: Integer)
      )(_.instancesWithUnreportedNotApplicablePatches)
      .optionallyWith(
        instancesWithCriticalNonCompliantPatches.map(value =>
          InstancesCount.unwrap(value): Integer
        )
      )(_.instancesWithCriticalNonCompliantPatches)
      .optionallyWith(
        instancesWithSecurityNonCompliantPatches.map(value =>
          InstancesCount.unwrap(value): Integer
        )
      )(_.instancesWithSecurityNonCompliantPatches)
      .optionallyWith(
        instancesWithOtherNonCompliantPatches.map(value =>
          InstancesCount.unwrap(value): Integer
        )
      )(_.instancesWithOtherNonCompliantPatches)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribePatchGroupStateResponse.ReadOnly =
    zio.aws.ssm.model.DescribePatchGroupStateResponse.wrap(buildAwsValue())
}
object DescribePatchGroupStateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribePatchGroupStateResponse =
      zio.aws.ssm.model.DescribePatchGroupStateResponse(
        instances.map(value => value),
        instancesWithInstalledPatches.map(value => value),
        instancesWithInstalledOtherPatches.map(value => value),
        instancesWithInstalledPendingRebootPatches.map(value => value),
        instancesWithInstalledRejectedPatches.map(value => value),
        instancesWithMissingPatches.map(value => value),
        instancesWithFailedPatches.map(value => value),
        instancesWithNotApplicablePatches.map(value => value),
        instancesWithUnreportedNotApplicablePatches.map(value => value),
        instancesWithCriticalNonCompliantPatches.map(value => value),
        instancesWithSecurityNonCompliantPatches.map(value => value),
        instancesWithOtherNonCompliantPatches.map(value => value)
      )
    def instances: Option[zio.aws.ssm.model.primitives.Integer]
    def instancesWithInstalledPatches
        : Option[zio.aws.ssm.model.primitives.Integer]
    def instancesWithInstalledOtherPatches
        : Option[zio.aws.ssm.model.primitives.Integer]
    def instancesWithInstalledPendingRebootPatches: Option[InstancesCount]
    def instancesWithInstalledRejectedPatches: Option[InstancesCount]
    def instancesWithMissingPatches
        : Option[zio.aws.ssm.model.primitives.Integer]
    def instancesWithFailedPatches: Option[zio.aws.ssm.model.primitives.Integer]
    def instancesWithNotApplicablePatches
        : Option[zio.aws.ssm.model.primitives.Integer]
    def instancesWithUnreportedNotApplicablePatches
        : Option[zio.aws.ssm.model.primitives.Integer]
    def instancesWithCriticalNonCompliantPatches: Option[InstancesCount]
    def instancesWithSecurityNonCompliantPatches: Option[InstancesCount]
    def instancesWithOtherNonCompliantPatches: Option[InstancesCount]
    def getInstances: ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField("instances", instances)
    def getInstancesWithInstalledPatches
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField(
        "instancesWithInstalledPatches",
        instancesWithInstalledPatches
      )
    def getInstancesWithInstalledOtherPatches
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField(
        "instancesWithInstalledOtherPatches",
        instancesWithInstalledOtherPatches
      )
    def getInstancesWithInstalledPendingRebootPatches
        : ZIO[Any, AwsError, InstancesCount] = AwsError.unwrapOptionField(
      "instancesWithInstalledPendingRebootPatches",
      instancesWithInstalledPendingRebootPatches
    )
    def getInstancesWithInstalledRejectedPatches
        : ZIO[Any, AwsError, InstancesCount] = AwsError.unwrapOptionField(
      "instancesWithInstalledRejectedPatches",
      instancesWithInstalledRejectedPatches
    )
    def getInstancesWithMissingPatches
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField(
        "instancesWithMissingPatches",
        instancesWithMissingPatches
      )
    def getInstancesWithFailedPatches
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField(
        "instancesWithFailedPatches",
        instancesWithFailedPatches
      )
    def getInstancesWithNotApplicablePatches
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField(
        "instancesWithNotApplicablePatches",
        instancesWithNotApplicablePatches
      )
    def getInstancesWithUnreportedNotApplicablePatches
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField(
        "instancesWithUnreportedNotApplicablePatches",
        instancesWithUnreportedNotApplicablePatches
      )
    def getInstancesWithCriticalNonCompliantPatches
        : ZIO[Any, AwsError, InstancesCount] = AwsError.unwrapOptionField(
      "instancesWithCriticalNonCompliantPatches",
      instancesWithCriticalNonCompliantPatches
    )
    def getInstancesWithSecurityNonCompliantPatches
        : ZIO[Any, AwsError, InstancesCount] = AwsError.unwrapOptionField(
      "instancesWithSecurityNonCompliantPatches",
      instancesWithSecurityNonCompliantPatches
    )
    def getInstancesWithOtherNonCompliantPatches
        : ZIO[Any, AwsError, InstancesCount] = AwsError.unwrapOptionField(
      "instancesWithOtherNonCompliantPatches",
      instancesWithOtherNonCompliantPatches
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateResponse
  ) extends zio.aws.ssm.model.DescribePatchGroupStateResponse.ReadOnly {
    override val instances: Option[zio.aws.ssm.model.primitives.Integer] = scala
      .Option(impl.instances())
      .map(value => value: zio.aws.ssm.model.primitives.Integer)
    override val instancesWithInstalledPatches
        : Option[zio.aws.ssm.model.primitives.Integer] = scala
      .Option(impl.instancesWithInstalledPatches())
      .map(value => value: zio.aws.ssm.model.primitives.Integer)
    override val instancesWithInstalledOtherPatches
        : Option[zio.aws.ssm.model.primitives.Integer] = scala
      .Option(impl.instancesWithInstalledOtherPatches())
      .map(value => value: zio.aws.ssm.model.primitives.Integer)
    override val instancesWithInstalledPendingRebootPatches
        : Option[InstancesCount] = scala
      .Option(impl.instancesWithInstalledPendingRebootPatches())
      .map(value => zio.aws.ssm.model.primitives.InstancesCount(value))
    override val instancesWithInstalledRejectedPatches: Option[InstancesCount] =
      scala
        .Option(impl.instancesWithInstalledRejectedPatches())
        .map(value => zio.aws.ssm.model.primitives.InstancesCount(value))
    override val instancesWithMissingPatches
        : Option[zio.aws.ssm.model.primitives.Integer] = scala
      .Option(impl.instancesWithMissingPatches())
      .map(value => value: zio.aws.ssm.model.primitives.Integer)
    override val instancesWithFailedPatches
        : Option[zio.aws.ssm.model.primitives.Integer] = scala
      .Option(impl.instancesWithFailedPatches())
      .map(value => value: zio.aws.ssm.model.primitives.Integer)
    override val instancesWithNotApplicablePatches
        : Option[zio.aws.ssm.model.primitives.Integer] = scala
      .Option(impl.instancesWithNotApplicablePatches())
      .map(value => value: zio.aws.ssm.model.primitives.Integer)
    override val instancesWithUnreportedNotApplicablePatches
        : Option[zio.aws.ssm.model.primitives.Integer] = scala
      .Option(impl.instancesWithUnreportedNotApplicablePatches())
      .map(value => value: zio.aws.ssm.model.primitives.Integer)
    override val instancesWithCriticalNonCompliantPatches
        : Option[InstancesCount] = scala
      .Option(impl.instancesWithCriticalNonCompliantPatches())
      .map(value => zio.aws.ssm.model.primitives.InstancesCount(value))
    override val instancesWithSecurityNonCompliantPatches
        : Option[InstancesCount] = scala
      .Option(impl.instancesWithSecurityNonCompliantPatches())
      .map(value => zio.aws.ssm.model.primitives.InstancesCount(value))
    override val instancesWithOtherNonCompliantPatches: Option[InstancesCount] =
      scala
        .Option(impl.instancesWithOtherNonCompliantPatches())
        .map(value => zio.aws.ssm.model.primitives.InstancesCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateResponse
  ): zio.aws.ssm.model.DescribePatchGroupStateResponse.ReadOnly = new Wrapper(
    impl
  )
}
