package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  NextToken,
  MaintenanceWindowSearchMaxResults,
  MaintenanceWindowId
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeMaintenanceWindowScheduleRequest(
    windowId: Option[MaintenanceWindowId] = None,
    targets: Option[Iterable[zio.aws.ssm.model.Target]] = None,
    resourceType: Option[zio.aws.ssm.model.MaintenanceWindowResourceType] =
      None,
    filters: Option[Iterable[zio.aws.ssm.model.PatchOrchestratorFilter]] = None,
    maxResults: Option[MaintenanceWindowSearchMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest = {
    import DescribeMaintenanceWindowScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest
      .builder()
      .optionallyWith(
        windowId.map(value =>
          MaintenanceWindowId.unwrap(value): java.lang.String
        )
      )(_.windowId)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          MaintenanceWindowSearchMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeMaintenanceWindowScheduleRequest.ReadOnly =
    zio.aws.ssm.model.DescribeMaintenanceWindowScheduleRequest
      .wrap(buildAwsValue())
}
object DescribeMaintenanceWindowScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeMaintenanceWindowScheduleRequest =
      zio.aws.ssm.model.DescribeMaintenanceWindowScheduleRequest(
        windowId.map(value => value),
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceType.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def windowId: Option[MaintenanceWindowId]
    def targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]]
    def resourceType: Option[zio.aws.ssm.model.MaintenanceWindowResourceType]
    def filters
        : Option[List[zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly]]
    def maxResults: Option[MaintenanceWindowSearchMaxResults]
    def nextToken: Option[NextToken]
    def getWindowId: ZIO[Any, AwsError, MaintenanceWindowId] =
      AwsError.unwrapOptionField("windowId", windowId)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.ssm.model.MaintenanceWindowResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaintenanceWindowSearchMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest
  ) extends zio.aws.ssm.model.DescribeMaintenanceWindowScheduleRequest.ReadOnly {
    override val windowId: Option[MaintenanceWindowId] = scala
      .Option(impl.windowId())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowId(value))
    override val targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]] =
      scala
        .Option(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val resourceType
        : Option[zio.aws.ssm.model.MaintenanceWindowResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.ssm.model.MaintenanceWindowResourceType.wrap(value))
    override val filters
        : Option[List[zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.PatchOrchestratorFilter.wrap(item)
          }.toList
        )
    override val maxResults: Option[MaintenanceWindowSearchMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowSearchMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest
  ): zio.aws.ssm.model.DescribeMaintenanceWindowScheduleRequest.ReadOnly =
    new Wrapper(impl)
}
