package zio.aws.ssm.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  DateTime,
  OpsItemType,
  OpsItemPriority,
  OpsItemSource,
  OpsItemSeverity,
  OpsItemDataKey,
  OpsItemDescription,
  OpsItemTitle,
  OpsItemCategory
}
import scala.jdk.CollectionConverters._
final case class CreateOpsItemRequest(
    description: OpsItemDescription,
    opsItemType: Option[OpsItemType] = None,
    operationalData: Option[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue]
    ] = None,
    notifications: Option[Iterable[zio.aws.ssm.model.OpsItemNotification]] =
      None,
    priority: Option[OpsItemPriority] = None,
    relatedOpsItems: Option[Iterable[zio.aws.ssm.model.RelatedOpsItem]] = None,
    source: OpsItemSource,
    title: OpsItemTitle,
    tags: Option[Iterable[zio.aws.ssm.model.Tag]] = None,
    category: Option[OpsItemCategory] = None,
    severity: Option[OpsItemSeverity] = None,
    actualStartTime: Option[DateTime] = None,
    actualEndTime: Option[DateTime] = None,
    plannedStartTime: Option[DateTime] = None,
    plannedEndTime: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CreateOpsItemRequest = {
    import CreateOpsItemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CreateOpsItemRequest
      .builder()
      .description(OpsItemDescription.unwrap(description): java.lang.String)
      .optionallyWith(
        opsItemType.map(value => OpsItemType.unwrap(value): java.lang.String)
      )(_.opsItemType)
      .optionallyWith(
        operationalData.map(value =>
          value
            .map({ case (key, value) =>
              (OpsItemDataKey.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.operationalData)
      .optionallyWith(
        notifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.notifications)
      .optionallyWith(
        priority.map(value => OpsItemPriority.unwrap(value): Integer)
      )(_.priority)
      .optionallyWith(
        relatedOpsItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relatedOpsItems)
      .source(OpsItemSource.unwrap(source): java.lang.String)
      .title(OpsItemTitle.unwrap(title): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        category.map(value => OpsItemCategory.unwrap(value): java.lang.String)
      )(_.category)
      .optionallyWith(
        severity.map(value => OpsItemSeverity.unwrap(value): java.lang.String)
      )(_.severity)
      .optionallyWith(
        actualStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.actualStartTime)
      .optionallyWith(
        actualEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.actualEndTime)
      .optionallyWith(
        plannedStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.plannedStartTime)
      .optionallyWith(
        plannedEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.plannedEndTime)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CreateOpsItemRequest.ReadOnly =
    zio.aws.ssm.model.CreateOpsItemRequest.wrap(buildAwsValue())
}
object CreateOpsItemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CreateOpsItemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CreateOpsItemRequest =
      zio.aws.ssm.model.CreateOpsItemRequest(
        description,
        opsItemType.map(value => value),
        operationalData.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        notifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        priority.map(value => value),
        relatedOpsItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        source,
        title,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        category.map(value => value),
        severity.map(value => value),
        actualStartTime.map(value => value),
        actualEndTime.map(value => value),
        plannedStartTime.map(value => value),
        plannedEndTime.map(value => value)
      )
    def description: OpsItemDescription
    def opsItemType: Option[OpsItemType]
    def operationalData: Option[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue.ReadOnly]
    ]
    def notifications
        : Option[List[zio.aws.ssm.model.OpsItemNotification.ReadOnly]]
    def priority: Option[OpsItemPriority]
    def relatedOpsItems: Option[List[zio.aws.ssm.model.RelatedOpsItem.ReadOnly]]
    def source: OpsItemSource
    def title: OpsItemTitle
    def tags: Option[List[zio.aws.ssm.model.Tag.ReadOnly]]
    def category: Option[OpsItemCategory]
    def severity: Option[OpsItemSeverity]
    def actualStartTime: Option[DateTime]
    def actualEndTime: Option[DateTime]
    def plannedStartTime: Option[DateTime]
    def plannedEndTime: Option[DateTime]
    def getDescription: ZIO[Any, Nothing, OpsItemDescription] =
      ZIO.succeed(description)
    def getOpsItemType: ZIO[Any, AwsError, OpsItemType] =
      AwsError.unwrapOptionField("opsItemType", opsItemType)
    def getOperationalData: ZIO[Any, AwsError, Map[
      OpsItemDataKey,
      zio.aws.ssm.model.OpsItemDataValue.ReadOnly
    ]] = AwsError.unwrapOptionField("operationalData", operationalData)
    def getNotifications: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.OpsItemNotification.ReadOnly
    ]] = AwsError.unwrapOptionField("notifications", notifications)
    def getPriority: ZIO[Any, AwsError, OpsItemPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getRelatedOpsItems
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.RelatedOpsItem.ReadOnly]] =
      AwsError.unwrapOptionField("relatedOpsItems", relatedOpsItems)
    def getSource: ZIO[Any, Nothing, OpsItemSource] = ZIO.succeed(source)
    def getTitle: ZIO[Any, Nothing, OpsItemTitle] = ZIO.succeed(title)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ssm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCategory: ZIO[Any, AwsError, OpsItemCategory] =
      AwsError.unwrapOptionField("category", category)
    def getSeverity: ZIO[Any, AwsError, OpsItemSeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getActualStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("actualStartTime", actualStartTime)
    def getActualEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("actualEndTime", actualEndTime)
    def getPlannedStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("plannedStartTime", plannedStartTime)
    def getPlannedEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("plannedEndTime", plannedEndTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CreateOpsItemRequest
  ) extends zio.aws.ssm.model.CreateOpsItemRequest.ReadOnly {
    override val description: OpsItemDescription =
      zio.aws.ssm.model.primitives.OpsItemDescription(impl.description())
    override val opsItemType: Option[OpsItemType] = scala
      .Option(impl.opsItemType())
      .map(value => zio.aws.ssm.model.primitives.OpsItemType(value))
    override val operationalData: Option[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue.ReadOnly]
    ] = scala
      .Option(impl.operationalData())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives.OpsItemDataKey(
              key
            ) -> zio.aws.ssm.model.OpsItemDataValue.wrap(value)
          })
          .toMap
      )
    override val notifications
        : Option[List[zio.aws.ssm.model.OpsItemNotification.ReadOnly]] = scala
      .Option(impl.notifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.OpsItemNotification.wrap(item)
        }.toList
      )
    override val priority: Option[OpsItemPriority] = scala
      .Option(impl.priority())
      .map(value => zio.aws.ssm.model.primitives.OpsItemPriority(value))
    override val relatedOpsItems
        : Option[List[zio.aws.ssm.model.RelatedOpsItem.ReadOnly]] = scala
      .Option(impl.relatedOpsItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.RelatedOpsItem.wrap(item)
        }.toList
      )
    override val source: OpsItemSource =
      zio.aws.ssm.model.primitives.OpsItemSource(impl.source())
    override val title: OpsItemTitle =
      zio.aws.ssm.model.primitives.OpsItemTitle(impl.title())
    override val tags: Option[List[zio.aws.ssm.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.Tag.wrap(item)
        }.toList
      )
    override val category: Option[OpsItemCategory] = scala
      .Option(impl.category())
      .map(value => zio.aws.ssm.model.primitives.OpsItemCategory(value))
    override val severity: Option[OpsItemSeverity] = scala
      .Option(impl.severity())
      .map(value => zio.aws.ssm.model.primitives.OpsItemSeverity(value))
    override val actualStartTime: Option[DateTime] = scala
      .Option(impl.actualStartTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val actualEndTime: Option[DateTime] = scala
      .Option(impl.actualEndTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val plannedStartTime: Option[DateTime] = scala
      .Option(impl.plannedStartTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val plannedEndTime: Option[DateTime] = scala
      .Option(impl.plannedEndTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CreateOpsItemRequest
  ): zio.aws.ssm.model.CreateOpsItemRequest.ReadOnly = new Wrapper(impl)
}
