package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  PSParameterName,
  ParameterDescription,
  AllowedPattern,
  PSParameterValue,
  ParameterKeyId,
  ParameterDataType,
  ParameterPolicies
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutParameterRequest(
    name: PSParameterName,
    description: Option[ParameterDescription] = None,
    value: PSParameterValue,
    `type`: Option[zio.aws.ssm.model.ParameterType] = None,
    keyId: Option[ParameterKeyId] = None,
    overwrite: Option[Boolean] = None,
    allowedPattern: Option[AllowedPattern] = None,
    tags: Option[Iterable[zio.aws.ssm.model.Tag]] = None,
    tier: Option[zio.aws.ssm.model.ParameterTier] = None,
    policies: Option[ParameterPolicies] = None,
    dataType: Option[ParameterDataType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.PutParameterRequest = {
    import PutParameterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.PutParameterRequest
      .builder()
      .name(PSParameterName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ParameterDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .value(PSParameterValue.unwrap(value): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        keyId.map(value => ParameterKeyId.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(overwrite.map(value => value: java.lang.Boolean))(
        _.overwrite
      )
      .optionallyWith(
        allowedPattern.map(value =>
          AllowedPattern.unwrap(value): java.lang.String
        )
      )(_.allowedPattern)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(tier.map(value => value.unwrap))(_.tier)
      .optionallyWith(
        policies.map(value => ParameterPolicies.unwrap(value): java.lang.String)
      )(_.policies)
      .optionallyWith(
        dataType.map(value => ParameterDataType.unwrap(value): java.lang.String)
      )(_.dataType)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.PutParameterRequest.ReadOnly =
    zio.aws.ssm.model.PutParameterRequest.wrap(buildAwsValue())
}
object PutParameterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.PutParameterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.PutParameterRequest =
      zio.aws.ssm.model.PutParameterRequest(
        name,
        description.map(value => value),
        value,
        `type`.map(value => value),
        keyId.map(value => value),
        overwrite.map(value => value),
        allowedPattern.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tier.map(value => value),
        policies.map(value => value),
        dataType.map(value => value)
      )
    def name: PSParameterName
    def description: Option[ParameterDescription]
    def value: PSParameterValue
    def `type`: Option[zio.aws.ssm.model.ParameterType]
    def keyId: Option[ParameterKeyId]
    def overwrite: Option[Boolean]
    def allowedPattern: Option[AllowedPattern]
    def tags: Option[List[zio.aws.ssm.model.Tag.ReadOnly]]
    def tier: Option[zio.aws.ssm.model.ParameterTier]
    def policies: Option[ParameterPolicies]
    def dataType: Option[ParameterDataType]
    def getName: ZIO[Any, Nothing, PSParameterName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, ParameterDescription] =
      AwsError.unwrapOptionField("description", description)
    def getValue: ZIO[Any, Nothing, PSParameterValue] = ZIO.succeed(value)
    def getType: ZIO[Any, AwsError, zio.aws.ssm.model.ParameterType] =
      AwsError.unwrapOptionField("type", `type`)
    def getKeyId: ZIO[Any, AwsError, ParameterKeyId] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getOverwrite: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("overwrite", overwrite)
    def getAllowedPattern: ZIO[Any, AwsError, AllowedPattern] =
      AwsError.unwrapOptionField("allowedPattern", allowedPattern)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ssm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTier: ZIO[Any, AwsError, zio.aws.ssm.model.ParameterTier] =
      AwsError.unwrapOptionField("tier", tier)
    def getPolicies: ZIO[Any, AwsError, ParameterPolicies] =
      AwsError.unwrapOptionField("policies", policies)
    def getDataType: ZIO[Any, AwsError, ParameterDataType] =
      AwsError.unwrapOptionField("dataType", dataType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.PutParameterRequest
  ) extends zio.aws.ssm.model.PutParameterRequest.ReadOnly {
    override val name: PSParameterName =
      zio.aws.ssm.model.primitives.PSParameterName(impl.name())
    override val description: Option[ParameterDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.ssm.model.primitives.ParameterDescription(value))
    override val value: PSParameterValue =
      zio.aws.ssm.model.primitives.PSParameterValue(impl.value())
    override val `type`: Option[zio.aws.ssm.model.ParameterType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.ssm.model.ParameterType.wrap(value))
    override val keyId: Option[ParameterKeyId] = scala
      .Option(impl.keyId())
      .map(value => zio.aws.ssm.model.primitives.ParameterKeyId(value))
    override val overwrite: Option[Boolean] =
      scala.Option(impl.overwrite()).map(value => value: Boolean)
    override val allowedPattern: Option[AllowedPattern] = scala
      .Option(impl.allowedPattern())
      .map(value => zio.aws.ssm.model.primitives.AllowedPattern(value))
    override val tags: Option[List[zio.aws.ssm.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.Tag.wrap(item)
        }.toList
      )
    override val tier: Option[zio.aws.ssm.model.ParameterTier] = scala
      .Option(impl.tier())
      .map(value => zio.aws.ssm.model.ParameterTier.wrap(value))
    override val policies: Option[ParameterPolicies] = scala
      .Option(impl.policies())
      .map(value => zio.aws.ssm.model.primitives.ParameterPolicies(value))
    override val dataType: Option[ParameterDataType] = scala
      .Option(impl.dataType())
      .map(value => zio.aws.ssm.model.primitives.ParameterDataType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.PutParameterRequest
  ): zio.aws.ssm.model.PutParameterRequest.ReadOnly = new Wrapper(impl)
}
