package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.MaintenanceWindowTaskParameterValue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MaintenanceWindowTaskParameterValueExpression(
    values: Option[Iterable[MaintenanceWindowTaskParameterValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParameterValueExpression = {
    import MaintenanceWindowTaskParameterValueExpression.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParameterValueExpression
      .builder()
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            MaintenanceWindowTaskParameterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression.ReadOnly =
    zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression
      .wrap(buildAwsValue())
}
object MaintenanceWindowTaskParameterValueExpression {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParameterValueExpression
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression =
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression(
        values.map(value => value)
      )
    def values: Option[List[MaintenanceWindowTaskParameterValue]]
    def getValues
        : ZIO[Any, AwsError, List[MaintenanceWindowTaskParameterValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParameterValueExpression
  ) extends zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression.ReadOnly {
    override val values: Option[List[MaintenanceWindowTaskParameterValue]] =
      scala
        .Option(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives
              .MaintenanceWindowTaskParameterValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParameterValueExpression
  ): zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression.ReadOnly =
    new Wrapper(impl)
}
