package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListOpsItemEventsResponse(
    nextToken: Option[String] = None,
    summaries: Option[Iterable[zio.aws.ssm.model.OpsItemEventSummary]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListOpsItemEventsResponse = {
    import ListOpsItemEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListOpsItemEventsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        summaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaries)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListOpsItemEventsResponse.ReadOnly =
    zio.aws.ssm.model.ListOpsItemEventsResponse.wrap(buildAwsValue())
}
object ListOpsItemEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListOpsItemEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListOpsItemEventsResponse =
      zio.aws.ssm.model.ListOpsItemEventsResponse(
        nextToken.map(value => value),
        summaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[String]
    def summaries: Option[List[zio.aws.ssm.model.OpsItemEventSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSummaries: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.OpsItemEventSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaries", summaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListOpsItemEventsResponse
  ) extends zio.aws.ssm.model.ListOpsItemEventsResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val summaries
        : Option[List[zio.aws.ssm.model.OpsItemEventSummary.ReadOnly]] = scala
      .Option(impl.summaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.OpsItemEventSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListOpsItemEventsResponse
  ): zio.aws.ssm.model.ListOpsItemEventsResponse.ReadOnly = new Wrapper(impl)
}
