package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{Reviewer, DateTime}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DocumentReviewerResponseSource(
    createTime: Option[DateTime] = None,
    updatedTime: Option[DateTime] = None,
    reviewStatus: Option[zio.aws.ssm.model.ReviewStatus] = None,
    comment: Option[Iterable[zio.aws.ssm.model.DocumentReviewCommentSource]] =
      None,
    reviewer: Option[Reviewer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DocumentReviewerResponseSource = {
    import DocumentReviewerResponseSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DocumentReviewerResponseSource
      .builder()
      .optionallyWith(createTime.map(value => DateTime.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(
        updatedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.updatedTime)
      .optionallyWith(reviewStatus.map(value => value.unwrap))(_.reviewStatus)
      .optionallyWith(
        comment.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.comment)
      .optionallyWith(
        reviewer.map(value => Reviewer.unwrap(value): java.lang.String)
      )(_.reviewer)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DocumentReviewerResponseSource.ReadOnly =
    zio.aws.ssm.model.DocumentReviewerResponseSource.wrap(buildAwsValue())
}
object DocumentReviewerResponseSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DocumentReviewerResponseSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DocumentReviewerResponseSource =
      zio.aws.ssm.model.DocumentReviewerResponseSource(
        createTime.map(value => value),
        updatedTime.map(value => value),
        reviewStatus.map(value => value),
        comment.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reviewer.map(value => value)
      )
    def createTime: Option[DateTime]
    def updatedTime: Option[DateTime]
    def reviewStatus: Option[zio.aws.ssm.model.ReviewStatus]
    def comment
        : Option[List[zio.aws.ssm.model.DocumentReviewCommentSource.ReadOnly]]
    def reviewer: Option[Reviewer]
    def getCreateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getUpdatedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("updatedTime", updatedTime)
    def getReviewStatus: ZIO[Any, AwsError, zio.aws.ssm.model.ReviewStatus] =
      AwsError.unwrapOptionField("reviewStatus", reviewStatus)
    def getComment: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.DocumentReviewCommentSource.ReadOnly
    ]] = AwsError.unwrapOptionField("comment", comment)
    def getReviewer: ZIO[Any, AwsError, Reviewer] =
      AwsError.unwrapOptionField("reviewer", reviewer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DocumentReviewerResponseSource
  ) extends zio.aws.ssm.model.DocumentReviewerResponseSource.ReadOnly {
    override val createTime: Option[DateTime] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val updatedTime: Option[DateTime] = scala
      .Option(impl.updatedTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val reviewStatus: Option[zio.aws.ssm.model.ReviewStatus] = scala
      .Option(impl.reviewStatus())
      .map(value => zio.aws.ssm.model.ReviewStatus.wrap(value))
    override val comment
        : Option[List[zio.aws.ssm.model.DocumentReviewCommentSource.ReadOnly]] =
      scala
        .Option(impl.comment())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.DocumentReviewCommentSource.wrap(item)
          }.toList
        )
    override val reviewer: Option[Reviewer] = scala
      .Option(impl.reviewer())
      .map(value => zio.aws.ssm.model.primitives.Reviewer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DocumentReviewerResponseSource
  ): zio.aws.ssm.model.DocumentReviewerResponseSource.ReadOnly = new Wrapper(
    impl
  )
}
