package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DocumentMetadataResponseInfo(
    reviewerResponse: Option[
      Iterable[zio.aws.ssm.model.DocumentReviewerResponseSource]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DocumentMetadataResponseInfo = {
    import DocumentMetadataResponseInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DocumentMetadataResponseInfo
      .builder()
      .optionallyWith(
        reviewerResponse.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reviewerResponse)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DocumentMetadataResponseInfo.ReadOnly =
    zio.aws.ssm.model.DocumentMetadataResponseInfo.wrap(buildAwsValue())
}
object DocumentMetadataResponseInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DocumentMetadataResponseInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DocumentMetadataResponseInfo =
      zio.aws.ssm.model.DocumentMetadataResponseInfo(
        reviewerResponse.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def reviewerResponse: Option[
      List[zio.aws.ssm.model.DocumentReviewerResponseSource.ReadOnly]
    ]
    def getReviewerResponse: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.DocumentReviewerResponseSource.ReadOnly
    ]] = AwsError.unwrapOptionField("reviewerResponse", reviewerResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DocumentMetadataResponseInfo
  ) extends zio.aws.ssm.model.DocumentMetadataResponseInfo.ReadOnly {
    override val reviewerResponse: Option[
      List[zio.aws.ssm.model.DocumentReviewerResponseSource.ReadOnly]
    ] = scala
      .Option(impl.reviewerResponse())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.DocumentReviewerResponseSource.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DocumentMetadataResponseInfo
  ): zio.aws.ssm.model.DocumentMetadataResponseInfo.ReadOnly = new Wrapper(impl)
}
