package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowId,
  OwnerInformation,
  MaintenanceWindowTargetId,
  MaintenanceWindowName,
  MaintenanceWindowDescription
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateMaintenanceWindowTargetRequest(
    windowId: MaintenanceWindowId,
    windowTargetId: MaintenanceWindowTargetId,
    targets: Option[Iterable[zio.aws.ssm.model.Target]] = None,
    ownerInformation: Option[OwnerInformation] = None,
    name: Option[MaintenanceWindowName] = None,
    description: Option[MaintenanceWindowDescription] = None,
    replace: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTargetRequest = {
    import UpdateMaintenanceWindowTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTargetRequest
      .builder()
      .windowId(MaintenanceWindowId.unwrap(windowId): java.lang.String)
      .windowTargetId(
        MaintenanceWindowTargetId.unwrap(windowTargetId): java.lang.String
      )
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        ownerInformation.map(value =>
          OwnerInformation.unwrap(value): java.lang.String
        )
      )(_.ownerInformation)
      .optionallyWith(
        name.map(value => MaintenanceWindowName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          MaintenanceWindowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(replace.map(value => value: java.lang.Boolean))(_.replace)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.UpdateMaintenanceWindowTargetRequest.ReadOnly =
    zio.aws.ssm.model.UpdateMaintenanceWindowTargetRequest.wrap(buildAwsValue())
}
object UpdateMaintenanceWindowTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateMaintenanceWindowTargetRequest =
      zio.aws.ssm.model.UpdateMaintenanceWindowTargetRequest(
        windowId,
        windowTargetId,
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ownerInformation.map(value => value),
        name.map(value => value),
        description.map(value => value),
        replace.map(value => value)
      )
    def windowId: MaintenanceWindowId
    def windowTargetId: MaintenanceWindowTargetId
    def targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]]
    def ownerInformation: Option[OwnerInformation]
    def name: Option[MaintenanceWindowName]
    def description: Option[MaintenanceWindowDescription]
    def replace: Option[Boolean]
    def getWindowId: ZIO[Any, Nothing, MaintenanceWindowId] =
      ZIO.succeed(windowId)
    def getWindowTargetId: ZIO[Any, Nothing, MaintenanceWindowTargetId] =
      ZIO.succeed(windowTargetId)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getOwnerInformation: ZIO[Any, AwsError, OwnerInformation] =
      AwsError.unwrapOptionField("ownerInformation", ownerInformation)
    def getName: ZIO[Any, AwsError, MaintenanceWindowName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, MaintenanceWindowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getReplace: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("replace", replace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTargetRequest
  ) extends zio.aws.ssm.model.UpdateMaintenanceWindowTargetRequest.ReadOnly {
    override val windowId: MaintenanceWindowId =
      zio.aws.ssm.model.primitives.MaintenanceWindowId(impl.windowId())
    override val windowTargetId: MaintenanceWindowTargetId =
      zio.aws.ssm.model.primitives
        .MaintenanceWindowTargetId(impl.windowTargetId())
    override val targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]] =
      scala
        .Option(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val ownerInformation: Option[OwnerInformation] = scala
      .Option(impl.ownerInformation())
      .map(value => zio.aws.ssm.model.primitives.OwnerInformation(value))
    override val name: Option[MaintenanceWindowName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowName(value))
    override val description: Option[MaintenanceWindowDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowDescription(value)
      )
    override val replace: Option[Boolean] =
      scala.Option(impl.replace()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTargetRequest
  ): zio.aws.ssm.model.UpdateMaintenanceWindowTargetRequest.ReadOnly =
    new Wrapper(impl)
}
