package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{StreamUrl, TokenValue, SessionId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartSessionResponse(
    sessionId: Option[SessionId] = None,
    tokenValue: Option[TokenValue] = None,
    streamUrl: Option[StreamUrl] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.StartSessionResponse = {
    import StartSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.StartSessionResponse
      .builder()
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .optionallyWith(
        tokenValue.map(value => TokenValue.unwrap(value): java.lang.String)
      )(_.tokenValue)
      .optionallyWith(
        streamUrl.map(value => StreamUrl.unwrap(value): java.lang.String)
      )(_.streamUrl)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.StartSessionResponse.ReadOnly =
    zio.aws.ssm.model.StartSessionResponse.wrap(buildAwsValue())
}
object StartSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.StartSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.StartSessionResponse =
      zio.aws.ssm.model.StartSessionResponse(
        sessionId.map(value => value),
        tokenValue.map(value => value),
        streamUrl.map(value => value)
      )
    def sessionId: Option[SessionId]
    def tokenValue: Option[TokenValue]
    def streamUrl: Option[StreamUrl]
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getTokenValue: ZIO[Any, AwsError, TokenValue] =
      AwsError.unwrapOptionField("tokenValue", tokenValue)
    def getStreamUrl: ZIO[Any, AwsError, StreamUrl] =
      AwsError.unwrapOptionField("streamUrl", streamUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.StartSessionResponse
  ) extends zio.aws.ssm.model.StartSessionResponse.ReadOnly {
    override val sessionId: Option[SessionId] = scala
      .Option(impl.sessionId())
      .map(value => zio.aws.ssm.model.primitives.SessionId(value))
    override val tokenValue: Option[TokenValue] = scala
      .Option(impl.tokenValue())
      .map(value => zio.aws.ssm.model.primitives.TokenValue(value))
    override val streamUrl: Option[StreamUrl] = scala
      .Option(impl.streamUrl())
      .map(value => zio.aws.ssm.model.primitives.StreamUrl(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.StartSessionResponse
  ): zio.aws.ssm.model.StartSessionResponse.ReadOnly = new Wrapper(impl)
}
