package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  SessionTarget,
  SessionDetails,
  MaxSessionDuration,
  DocumentName,
  SessionReason,
  DateTime,
  SessionOwner,
  SessionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Session(
    sessionId: Option[SessionId] = None,
    target: Option[SessionTarget] = None,
    status: Option[zio.aws.ssm.model.SessionStatus] = None,
    startDate: Option[DateTime] = None,
    endDate: Option[DateTime] = None,
    documentName: Option[DocumentName] = None,
    owner: Option[SessionOwner] = None,
    reason: Option[SessionReason] = None,
    details: Option[SessionDetails] = None,
    outputUrl: Option[zio.aws.ssm.model.SessionManagerOutputUrl] = None,
    maxSessionDuration: Option[MaxSessionDuration] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.Session = {
    import Session.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.Session
      .builder()
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .optionallyWith(
        target.map(value => SessionTarget.unwrap(value): java.lang.String)
      )(_.target)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(startDate.map(value => DateTime.unwrap(value): Instant))(
        _.startDate
      )
      .optionallyWith(endDate.map(value => DateTime.unwrap(value): Instant))(
        _.endDate
      )
      .optionallyWith(
        documentName.map(value => DocumentName.unwrap(value): java.lang.String)
      )(_.documentName)
      .optionallyWith(
        owner.map(value => SessionOwner.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        reason.map(value => SessionReason.unwrap(value): java.lang.String)
      )(_.reason)
      .optionallyWith(
        details.map(value => SessionDetails.unwrap(value): java.lang.String)
      )(_.details)
      .optionallyWith(outputUrl.map(value => value.buildAwsValue()))(
        _.outputUrl
      )
      .optionallyWith(
        maxSessionDuration.map(value =>
          MaxSessionDuration.unwrap(value): java.lang.String
        )
      )(_.maxSessionDuration)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.Session.ReadOnly =
    zio.aws.ssm.model.Session.wrap(buildAwsValue())
}
object Session {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.Session] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.Session = zio.aws.ssm.model.Session(
      sessionId.map(value => value),
      target.map(value => value),
      status.map(value => value),
      startDate.map(value => value),
      endDate.map(value => value),
      documentName.map(value => value),
      owner.map(value => value),
      reason.map(value => value),
      details.map(value => value),
      outputUrl.map(value => value.asEditable),
      maxSessionDuration.map(value => value)
    )
    def sessionId: Option[SessionId]
    def target: Option[SessionTarget]
    def status: Option[zio.aws.ssm.model.SessionStatus]
    def startDate: Option[DateTime]
    def endDate: Option[DateTime]
    def documentName: Option[DocumentName]
    def owner: Option[SessionOwner]
    def reason: Option[SessionReason]
    def details: Option[SessionDetails]
    def outputUrl: Option[zio.aws.ssm.model.SessionManagerOutputUrl.ReadOnly]
    def maxSessionDuration: Option[MaxSessionDuration]
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getTarget: ZIO[Any, AwsError, SessionTarget] =
      AwsError.unwrapOptionField("target", target)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssm.model.SessionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStartDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getDocumentName: ZIO[Any, AwsError, DocumentName] =
      AwsError.unwrapOptionField("documentName", documentName)
    def getOwner: ZIO[Any, AwsError, SessionOwner] =
      AwsError.unwrapOptionField("owner", owner)
    def getReason: ZIO[Any, AwsError, SessionReason] =
      AwsError.unwrapOptionField("reason", reason)
    def getDetails: ZIO[Any, AwsError, SessionDetails] =
      AwsError.unwrapOptionField("details", details)
    def getOutputUrl: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.SessionManagerOutputUrl.ReadOnly
    ] = AwsError.unwrapOptionField("outputUrl", outputUrl)
    def getMaxSessionDuration: ZIO[Any, AwsError, MaxSessionDuration] =
      AwsError.unwrapOptionField("maxSessionDuration", maxSessionDuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.Session
  ) extends zio.aws.ssm.model.Session.ReadOnly {
    override val sessionId: Option[SessionId] = scala
      .Option(impl.sessionId())
      .map(value => zio.aws.ssm.model.primitives.SessionId(value))
    override val target: Option[SessionTarget] = scala
      .Option(impl.target())
      .map(value => zio.aws.ssm.model.primitives.SessionTarget(value))
    override val status: Option[zio.aws.ssm.model.SessionStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.ssm.model.SessionStatus.wrap(value))
    override val startDate: Option[DateTime] = scala
      .Option(impl.startDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val endDate: Option[DateTime] = scala
      .Option(impl.endDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val documentName: Option[DocumentName] = scala
      .Option(impl.documentName())
      .map(value => zio.aws.ssm.model.primitives.DocumentName(value))
    override val owner: Option[SessionOwner] = scala
      .Option(impl.owner())
      .map(value => zio.aws.ssm.model.primitives.SessionOwner(value))
    override val reason: Option[SessionReason] = scala
      .Option(impl.reason())
      .map(value => zio.aws.ssm.model.primitives.SessionReason(value))
    override val details: Option[SessionDetails] = scala
      .Option(impl.details())
      .map(value => zio.aws.ssm.model.primitives.SessionDetails(value))
    override val outputUrl
        : Option[zio.aws.ssm.model.SessionManagerOutputUrl.ReadOnly] = scala
      .Option(impl.outputUrl())
      .map(value => zio.aws.ssm.model.SessionManagerOutputUrl.wrap(value))
    override val maxSessionDuration: Option[MaxSessionDuration] = scala
      .Option(impl.maxSessionDuration())
      .map(value => zio.aws.ssm.model.primitives.MaxSessionDuration(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.Session
  ): zio.aws.ssm.model.Session.ReadOnly = new Wrapper(impl)
}
