package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SendCommandResponse(
    command: Option[zio.aws.ssm.model.Command] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.SendCommandResponse = {
    import SendCommandResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.SendCommandResponse
      .builder()
      .optionallyWith(command.map(value => value.buildAwsValue()))(_.command)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.SendCommandResponse.ReadOnly =
    zio.aws.ssm.model.SendCommandResponse.wrap(buildAwsValue())
}
object SendCommandResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.SendCommandResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.SendCommandResponse = zio.aws.ssm.model
      .SendCommandResponse(command.map(value => value.asEditable))
    def command: Option[zio.aws.ssm.model.Command.ReadOnly]
    def getCommand: ZIO[Any, AwsError, zio.aws.ssm.model.Command.ReadOnly] =
      AwsError.unwrapOptionField("command", command)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.SendCommandResponse
  ) extends zio.aws.ssm.model.SendCommandResponse.ReadOnly {
    override val command: Option[zio.aws.ssm.model.Command.ReadOnly] = scala
      .Option(impl.command())
      .map(value => zio.aws.ssm.model.Command.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.SendCommandResponse
  ): zio.aws.ssm.model.SendCommandResponse.ReadOnly = new Wrapper(impl)
}
