package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  AutomationParameterValue,
  DocumentARN,
  DocumentVersion,
  AutomationParameterKey,
  MaxConcurrency,
  MaxErrors
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Runbook(
    documentName: DocumentARN,
    documentVersion: Option[DocumentVersion] = None,
    parameters: Option[
      Map[AutomationParameterKey, Iterable[AutomationParameterValue]]
    ] = None,
    targetParameterName: Option[AutomationParameterKey] = None,
    targets: Option[Iterable[zio.aws.ssm.model.Target]] = None,
    maxConcurrency: Option[MaxConcurrency] = None,
    maxErrors: Option[MaxErrors] = None,
    targetLocations: Option[Iterable[zio.aws.ssm.model.TargetLocation]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.Runbook = {
    import Runbook.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.Runbook
      .builder()
      .documentName(DocumentARN.unwrap(documentName): java.lang.String)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (AutomationParameterKey.unwrap(
                key
              ): java.lang.String) -> value.map { item =>
                AutomationParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        targetParameterName.map(value =>
          AutomationParameterKey.unwrap(value): java.lang.String
        )
      )(_.targetParameterName)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        maxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.maxConcurrency)
      .optionallyWith(
        maxErrors.map(value => MaxErrors.unwrap(value): java.lang.String)
      )(_.maxErrors)
      .optionallyWith(
        targetLocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetLocations)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.Runbook.ReadOnly =
    zio.aws.ssm.model.Runbook.wrap(buildAwsValue())
}
object Runbook {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.Runbook] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.Runbook = zio.aws.ssm.model.Runbook(
      documentName,
      documentVersion.map(value => value),
      parameters.map(value => value),
      targetParameterName.map(value => value),
      targets.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      maxConcurrency.map(value => value),
      maxErrors.map(value => value),
      targetLocations.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def documentName: DocumentARN
    def documentVersion: Option[DocumentVersion]
    def parameters
        : Option[Map[AutomationParameterKey, List[AutomationParameterValue]]]
    def targetParameterName: Option[AutomationParameterKey]
    def targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]]
    def maxConcurrency: Option[MaxConcurrency]
    def maxErrors: Option[MaxErrors]
    def targetLocations: Option[List[zio.aws.ssm.model.TargetLocation.ReadOnly]]
    def getDocumentName: ZIO[Any, Nothing, DocumentARN] =
      ZIO.succeed(documentName)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getParameters: ZIO[Any, AwsError, Map[AutomationParameterKey, List[
      AutomationParameterValue
    ]]] = AwsError.unwrapOptionField("parameters", parameters)
    def getTargetParameterName: ZIO[Any, AwsError, AutomationParameterKey] =
      AwsError.unwrapOptionField("targetParameterName", targetParameterName)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getMaxErrors: ZIO[Any, AwsError, MaxErrors] =
      AwsError.unwrapOptionField("maxErrors", maxErrors)
    def getTargetLocations
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.TargetLocation.ReadOnly]] =
      AwsError.unwrapOptionField("targetLocations", targetLocations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.Runbook
  ) extends zio.aws.ssm.model.Runbook.ReadOnly {
    override val documentName: DocumentARN =
      zio.aws.ssm.model.primitives.DocumentARN(impl.documentName())
    override val documentVersion: Option[DocumentVersion] = scala
      .Option(impl.documentVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val parameters
        : Option[Map[AutomationParameterKey, List[AutomationParameterValue]]] =
      scala
        .Option(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .AutomationParameterKey(key) -> value.asScala.map { item =>
                zio.aws.ssm.model.primitives.AutomationParameterValue(item)
              }.toList
            })
            .toMap
        )
    override val targetParameterName: Option[AutomationParameterKey] = scala
      .Option(impl.targetParameterName())
      .map(value => zio.aws.ssm.model.primitives.AutomationParameterKey(value))
    override val targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]] =
      scala
        .Option(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val maxConcurrency: Option[MaxConcurrency] = scala
      .Option(impl.maxConcurrency())
      .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val maxErrors: Option[MaxErrors] = scala
      .Option(impl.maxErrors())
      .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
    override val targetLocations
        : Option[List[zio.aws.ssm.model.TargetLocation.ReadOnly]] = scala
      .Option(impl.targetLocations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.TargetLocation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.Runbook
  ): zio.aws.ssm.model.Runbook.ReadOnly = new Wrapper(impl)
}
