package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.OpsItemDataValueString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OpsItemDataValue(
    value: Option[OpsItemDataValueString] = None,
    `type`: Option[zio.aws.ssm.model.OpsItemDataType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.OpsItemDataValue = {
    import OpsItemDataValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.OpsItemDataValue
      .builder()
      .optionallyWith(
        value.map(value =>
          OpsItemDataValueString.unwrap(value): java.lang.String
        )
      )(_.value)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.OpsItemDataValue.ReadOnly =
    zio.aws.ssm.model.OpsItemDataValue.wrap(buildAwsValue())
}
object OpsItemDataValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.OpsItemDataValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.OpsItemDataValue = zio.aws.ssm.model
      .OpsItemDataValue(value.map(value => value), `type`.map(value => value))
    def value: Option[OpsItemDataValueString]
    def `type`: Option[zio.aws.ssm.model.OpsItemDataType]
    def getValue: ZIO[Any, AwsError, OpsItemDataValueString] =
      AwsError.unwrapOptionField("value", value)
    def getType: ZIO[Any, AwsError, zio.aws.ssm.model.OpsItemDataType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.OpsItemDataValue
  ) extends zio.aws.ssm.model.OpsItemDataValue.ReadOnly {
    override val value: Option[OpsItemDataValueString] = scala
      .Option(impl.value())
      .map(value => zio.aws.ssm.model.primitives.OpsItemDataValueString(value))
    override val `type`: Option[zio.aws.ssm.model.OpsItemDataType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.ssm.model.OpsItemDataType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.OpsItemDataValue
  ): zio.aws.ssm.model.OpsItemDataValue.ReadOnly = new Wrapper(impl)
}
