package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListOpsMetadataResponse(
    opsMetadataList: Option[Iterable[zio.aws.ssm.model.OpsMetadata]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListOpsMetadataResponse = {
    import ListOpsMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListOpsMetadataResponse
      .builder()
      .optionallyWith(
        opsMetadataList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.opsMetadataList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListOpsMetadataResponse.ReadOnly =
    zio.aws.ssm.model.ListOpsMetadataResponse.wrap(buildAwsValue())
}
object ListOpsMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListOpsMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListOpsMetadataResponse =
      zio.aws.ssm.model.ListOpsMetadataResponse(
        opsMetadataList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def opsMetadataList: Option[List[zio.aws.ssm.model.OpsMetadata.ReadOnly]]
    def nextToken: Option[NextToken]
    def getOpsMetadataList
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.OpsMetadata.ReadOnly]] =
      AwsError.unwrapOptionField("opsMetadataList", opsMetadataList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListOpsMetadataResponse
  ) extends zio.aws.ssm.model.ListOpsMetadataResponse.ReadOnly {
    override val opsMetadataList
        : Option[List[zio.aws.ssm.model.OpsMetadata.ReadOnly]] = scala
      .Option(impl.opsMetadataList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.OpsMetadata.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListOpsMetadataResponse
  ): zio.aws.ssm.model.ListOpsMetadataResponse.ReadOnly = new Wrapper(impl)
}
