package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  NextToken,
  DocumentAuthor,
  DocumentVersion,
  DocumentName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDocumentMetadataHistoryResponse(
    name: Option[DocumentName] = None,
    documentVersion: Option[DocumentVersion] = None,
    author: Option[DocumentAuthor] = None,
    metadata: Option[zio.aws.ssm.model.DocumentMetadataResponseInfo] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryResponse = {
    import ListDocumentMetadataHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryResponse
      .builder()
      .optionallyWith(
        name.map(value => DocumentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        author.map(value => DocumentAuthor.unwrap(value): java.lang.String)
      )(_.author)
      .optionallyWith(metadata.map(value => value.buildAwsValue()))(_.metadata)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.ListDocumentMetadataHistoryResponse.ReadOnly =
    zio.aws.ssm.model.ListDocumentMetadataHistoryResponse.wrap(buildAwsValue())
}
object ListDocumentMetadataHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListDocumentMetadataHistoryResponse =
      zio.aws.ssm.model.ListDocumentMetadataHistoryResponse(
        name.map(value => value),
        documentVersion.map(value => value),
        author.map(value => value),
        metadata.map(value => value.asEditable),
        nextToken.map(value => value)
      )
    def name: Option[DocumentName]
    def documentVersion: Option[DocumentVersion]
    def author: Option[DocumentAuthor]
    def metadata
        : Option[zio.aws.ssm.model.DocumentMetadataResponseInfo.ReadOnly]
    def nextToken: Option[NextToken]
    def getName: ZIO[Any, AwsError, DocumentName] =
      AwsError.unwrapOptionField("name", name)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getAuthor: ZIO[Any, AwsError, DocumentAuthor] =
      AwsError.unwrapOptionField("author", author)
    def getMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.DocumentMetadataResponseInfo.ReadOnly
    ] = AwsError.unwrapOptionField("metadata", metadata)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryResponse
  ) extends zio.aws.ssm.model.ListDocumentMetadataHistoryResponse.ReadOnly {
    override val name: Option[DocumentName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.DocumentName(value))
    override val documentVersion: Option[DocumentVersion] = scala
      .Option(impl.documentVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val author: Option[DocumentAuthor] = scala
      .Option(impl.author())
      .map(value => zio.aws.ssm.model.primitives.DocumentAuthor(value))
    override val metadata
        : Option[zio.aws.ssm.model.DocumentMetadataResponseInfo.ReadOnly] =
      scala
        .Option(impl.metadata())
        .map(value =>
          zio.aws.ssm.model.DocumentMetadataResponseInfo.wrap(value)
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryResponse
  ): zio.aws.ssm.model.ListDocumentMetadataHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
