package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListComplianceSummariesResponse(
    complianceSummaryItems: Option[
      Iterable[zio.aws.ssm.model.ComplianceSummaryItem]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse = {
    import ListComplianceSummariesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse
      .builder()
      .optionallyWith(
        complianceSummaryItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.complianceSummaryItems)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListComplianceSummariesResponse.ReadOnly =
    zio.aws.ssm.model.ListComplianceSummariesResponse.wrap(buildAwsValue())
}
object ListComplianceSummariesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListComplianceSummariesResponse =
      zio.aws.ssm.model.ListComplianceSummariesResponse(
        complianceSummaryItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def complianceSummaryItems
        : Option[List[zio.aws.ssm.model.ComplianceSummaryItem.ReadOnly]]
    def nextToken: Option[NextToken]
    def getComplianceSummaryItems: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.ComplianceSummaryItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "complianceSummaryItems",
      complianceSummaryItems
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse
  ) extends zio.aws.ssm.model.ListComplianceSummariesResponse.ReadOnly {
    override val complianceSummaryItems
        : Option[List[zio.aws.ssm.model.ComplianceSummaryItem.ReadOnly]] = scala
      .Option(impl.complianceSummaryItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.ComplianceSummaryItem.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse
  ): zio.aws.ssm.model.ListComplianceSummariesResponse.ReadOnly = new Wrapper(
    impl
  )
}
