package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{PSParameterVersion, ParameterLabel}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LabelParameterVersionResponse(
    invalidLabels: Option[Iterable[ParameterLabel]] = None,
    parameterVersion: Option[PSParameterVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.LabelParameterVersionResponse = {
    import LabelParameterVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.LabelParameterVersionResponse
      .builder()
      .optionallyWith(
        invalidLabels.map(value =>
          value.map { item =>
            ParameterLabel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.invalidLabels)
      .optionallyWith(
        parameterVersion.map(value =>
          PSParameterVersion.unwrap(value): java.lang.Long
        )
      )(_.parameterVersion)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.LabelParameterVersionResponse.ReadOnly =
    zio.aws.ssm.model.LabelParameterVersionResponse.wrap(buildAwsValue())
}
object LabelParameterVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.LabelParameterVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.LabelParameterVersionResponse =
      zio.aws.ssm.model.LabelParameterVersionResponse(
        invalidLabels.map(value => value),
        parameterVersion.map(value => value)
      )
    def invalidLabels: Option[List[ParameterLabel]]
    def parameterVersion: Option[PSParameterVersion]
    def getInvalidLabels: ZIO[Any, AwsError, List[ParameterLabel]] =
      AwsError.unwrapOptionField("invalidLabels", invalidLabels)
    def getParameterVersion: ZIO[Any, AwsError, PSParameterVersion] =
      AwsError.unwrapOptionField("parameterVersion", parameterVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.LabelParameterVersionResponse
  ) extends zio.aws.ssm.model.LabelParameterVersionResponse.ReadOnly {
    override val invalidLabels: Option[List[ParameterLabel]] = scala
      .Option(impl.invalidLabels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.ParameterLabel(item)
        }.toList
      )
    override val parameterVersion: Option[PSParameterVersion] = scala
      .Option(impl.parameterVersion())
      .map(value => zio.aws.ssm.model.primitives.PSParameterVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.LabelParameterVersionResponse
  ): zio.aws.ssm.model.LabelParameterVersionResponse.ReadOnly = new Wrapper(
    impl
  )
}
