package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait InventoryQueryOperatorType {
  def unwrap
      : software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType
}
object InventoryQueryOperatorType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType
  ): zio.aws.ssm.model.InventoryQueryOperatorType = value match {
    case software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType.EQUAL =>
      val r = Equal
      r
    case software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType.NOT_EQUAL =>
      val r = NotEqual
      r
    case software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType.BEGIN_WITH =>
      val r = BeginWith
      r
    case software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType.LESS_THAN =>
      val r = LessThan
      r
    case software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType.GREATER_THAN =>
      val r = GreaterThan
      r
    case software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType.EXISTS =>
      val r = Exists
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.InventoryQueryOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType =
      software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType.UNKNOWN_TO_SDK_VERSION
  }
  case object Equal extends zio.aws.ssm.model.InventoryQueryOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType =
      software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType.EQUAL
  }
  case object NotEqual extends zio.aws.ssm.model.InventoryQueryOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType =
      software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType.NOT_EQUAL
  }
  case object BeginWith extends zio.aws.ssm.model.InventoryQueryOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType =
      software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType.BEGIN_WITH
  }
  case object LessThan extends zio.aws.ssm.model.InventoryQueryOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType =
      software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType.LESS_THAN
  }
  case object GreaterThan extends zio.aws.ssm.model.InventoryQueryOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType =
      software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType.GREATER_THAN
  }
  case object Exists extends zio.aws.ssm.model.InventoryQueryOperatorType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType =
      software.amazon.awssdk.services.ssm.model.InventoryQueryOperatorType.EXISTS
  }
}
