package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaxResults,
  NextToken,
  ResourceDataSyncName
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetOpsSummaryRequest(
    syncName: Option[ResourceDataSyncName] = None,
    filters: Option[Iterable[zio.aws.ssm.model.OpsFilter]] = None,
    aggregators: Option[Iterable[zio.aws.ssm.model.OpsAggregator]] = None,
    resultAttributes: Option[Iterable[zio.aws.ssm.model.OpsResultAttribute]] =
      None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest = {
    import GetOpsSummaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest
      .builder()
      .optionallyWith(
        syncName.map(value =>
          ResourceDataSyncName.unwrap(value): java.lang.String
        )
      )(_.syncName)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        aggregators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aggregators)
      .optionallyWith(
        resultAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resultAttributes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetOpsSummaryRequest.ReadOnly =
    zio.aws.ssm.model.GetOpsSummaryRequest.wrap(buildAwsValue())
}
object GetOpsSummaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetOpsSummaryRequest =
      zio.aws.ssm.model.GetOpsSummaryRequest(
        syncName.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        aggregators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resultAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def syncName: Option[ResourceDataSyncName]
    def filters: Option[List[zio.aws.ssm.model.OpsFilter.ReadOnly]]
    def aggregators: Option[List[zio.aws.ssm.model.OpsAggregator.ReadOnly]]
    def resultAttributes
        : Option[List[zio.aws.ssm.model.OpsResultAttribute.ReadOnly]]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getSyncName: ZIO[Any, AwsError, ResourceDataSyncName] =
      AwsError.unwrapOptionField("syncName", syncName)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.OpsFilter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getAggregators
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.OpsAggregator.ReadOnly]] =
      AwsError.unwrapOptionField("aggregators", aggregators)
    def getResultAttributes: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.OpsResultAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("resultAttributes", resultAttributes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest
  ) extends zio.aws.ssm.model.GetOpsSummaryRequest.ReadOnly {
    override val syncName: Option[ResourceDataSyncName] = scala
      .Option(impl.syncName())
      .map(value => zio.aws.ssm.model.primitives.ResourceDataSyncName(value))
    override val filters: Option[List[zio.aws.ssm.model.OpsFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.OpsFilter.wrap(item)
          }.toList
        )
    override val aggregators
        : Option[List[zio.aws.ssm.model.OpsAggregator.ReadOnly]] = scala
      .Option(impl.aggregators())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.OpsAggregator.wrap(item)
        }.toList
      )
    override val resultAttributes
        : Option[List[zio.aws.ssm.model.OpsResultAttribute.ReadOnly]] = scala
      .Option(impl.resultAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.OpsResultAttribute.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest
  ): zio.aws.ssm.model.GetOpsSummaryRequest.ReadOnly = new Wrapper(impl)
}
