package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  DateTime,
  MaintenanceWindowExecutionStatusDetails,
  MaintenanceWindowExecutionTaskId,
  MaintenanceWindowExecutionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetMaintenanceWindowExecutionResponse(
    windowExecutionId: Option[MaintenanceWindowExecutionId] = None,
    taskIds: Option[Iterable[MaintenanceWindowExecutionTaskId]] = None,
    status: Option[zio.aws.ssm.model.MaintenanceWindowExecutionStatus] = None,
    statusDetails: Option[MaintenanceWindowExecutionStatusDetails] = None,
    startTime: Option[DateTime] = None,
    endTime: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionResponse = {
    import GetMaintenanceWindowExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionResponse
      .builder()
      .optionallyWith(
        windowExecutionId.map(value =>
          MaintenanceWindowExecutionId.unwrap(value): java.lang.String
        )
      )(_.windowExecutionId)
      .optionallyWith(
        taskIds.map(value =>
          value.map { item =>
            MaintenanceWindowExecutionTaskId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.taskIds)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusDetails.map(value =>
          MaintenanceWindowExecutionStatusDetails.unwrap(
            value
          ): java.lang.String
        )
      )(_.statusDetails)
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => DateTime.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.GetMaintenanceWindowExecutionResponse.ReadOnly =
    zio.aws.ssm.model.GetMaintenanceWindowExecutionResponse
      .wrap(buildAwsValue())
}
object GetMaintenanceWindowExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetMaintenanceWindowExecutionResponse =
      zio.aws.ssm.model.GetMaintenanceWindowExecutionResponse(
        windowExecutionId.map(value => value),
        taskIds.map(value => value),
        status.map(value => value),
        statusDetails.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def windowExecutionId: Option[MaintenanceWindowExecutionId]
    def taskIds: Option[List[MaintenanceWindowExecutionTaskId]]
    def status: Option[zio.aws.ssm.model.MaintenanceWindowExecutionStatus]
    def statusDetails: Option[MaintenanceWindowExecutionStatusDetails]
    def startTime: Option[DateTime]
    def endTime: Option[DateTime]
    def getWindowExecutionId: ZIO[Any, AwsError, MaintenanceWindowExecutionId] =
      AwsError.unwrapOptionField("windowExecutionId", windowExecutionId)
    def getTaskIds: ZIO[Any, AwsError, List[MaintenanceWindowExecutionTaskId]] =
      AwsError.unwrapOptionField("taskIds", taskIds)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusDetails
        : ZIO[Any, AwsError, MaintenanceWindowExecutionStatusDetails] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionResponse
  ) extends zio.aws.ssm.model.GetMaintenanceWindowExecutionResponse.ReadOnly {
    override val windowExecutionId: Option[MaintenanceWindowExecutionId] = scala
      .Option(impl.windowExecutionId())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowExecutionId(value)
      )
    override val taskIds: Option[List[MaintenanceWindowExecutionTaskId]] = scala
      .Option(impl.taskIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.MaintenanceWindowExecutionTaskId(item)
        }.toList
      )
    override val status
        : Option[zio.aws.ssm.model.MaintenanceWindowExecutionStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.ssm.model.MaintenanceWindowExecutionStatus.wrap(value)
      )
    override val statusDetails
        : Option[MaintenanceWindowExecutionStatusDetails] = scala
      .Option(impl.statusDetails())
      .map(value =>
        zio.aws.ssm.model.primitives
          .MaintenanceWindowExecutionStatusDetails(value)
      )
    override val startTime: Option[DateTime] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val endTime: Option[DateTime] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionResponse
  ): zio.aws.ssm.model.GetMaintenanceWindowExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
