package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetDefaultPatchBaselineRequest(
    operatingSystem: Option[zio.aws.ssm.model.OperatingSystem] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineRequest = {
    import GetDefaultPatchBaselineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineRequest
      .builder()
      .optionallyWith(operatingSystem.map(value => value.unwrap))(
        _.operatingSystem
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetDefaultPatchBaselineRequest.ReadOnly =
    zio.aws.ssm.model.GetDefaultPatchBaselineRequest.wrap(buildAwsValue())
}
object GetDefaultPatchBaselineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetDefaultPatchBaselineRequest =
      zio.aws.ssm.model
        .GetDefaultPatchBaselineRequest(operatingSystem.map(value => value))
    def operatingSystem: Option[zio.aws.ssm.model.OperatingSystem]
    def getOperatingSystem
        : ZIO[Any, AwsError, zio.aws.ssm.model.OperatingSystem] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineRequest
  ) extends zio.aws.ssm.model.GetDefaultPatchBaselineRequest.ReadOnly {
    override val operatingSystem: Option[zio.aws.ssm.model.OperatingSystem] =
      scala
        .Option(impl.operatingSystem())
        .map(value => zio.aws.ssm.model.OperatingSystem.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineRequest
  ): zio.aws.ssm.model.GetDefaultPatchBaselineRequest.ReadOnly = new Wrapper(
    impl
  )
}
