package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.ISO8601String
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetCalendarStateResponse(
    state: Option[zio.aws.ssm.model.CalendarState] = None,
    atTime: Option[ISO8601String] = None,
    nextTransitionTime: Option[ISO8601String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetCalendarStateResponse = {
    import GetCalendarStateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetCalendarStateResponse
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        atTime.map(value => ISO8601String.unwrap(value): java.lang.String)
      )(_.atTime)
      .optionallyWith(
        nextTransitionTime.map(value =>
          ISO8601String.unwrap(value): java.lang.String
        )
      )(_.nextTransitionTime)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetCalendarStateResponse.ReadOnly =
    zio.aws.ssm.model.GetCalendarStateResponse.wrap(buildAwsValue())
}
object GetCalendarStateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetCalendarStateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetCalendarStateResponse =
      zio.aws.ssm.model.GetCalendarStateResponse(
        state.map(value => value),
        atTime.map(value => value),
        nextTransitionTime.map(value => value)
      )
    def state: Option[zio.aws.ssm.model.CalendarState]
    def atTime: Option[ISO8601String]
    def nextTransitionTime: Option[ISO8601String]
    def getState: ZIO[Any, AwsError, zio.aws.ssm.model.CalendarState] =
      AwsError.unwrapOptionField("state", state)
    def getAtTime: ZIO[Any, AwsError, ISO8601String] =
      AwsError.unwrapOptionField("atTime", atTime)
    def getNextTransitionTime: ZIO[Any, AwsError, ISO8601String] =
      AwsError.unwrapOptionField("nextTransitionTime", nextTransitionTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetCalendarStateResponse
  ) extends zio.aws.ssm.model.GetCalendarStateResponse.ReadOnly {
    override val state: Option[zio.aws.ssm.model.CalendarState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ssm.model.CalendarState.wrap(value))
    override val atTime: Option[ISO8601String] = scala
      .Option(impl.atTime())
      .map(value => zio.aws.ssm.model.primitives.ISO8601String(value))
    override val nextTransitionTime: Option[ISO8601String] = scala
      .Option(impl.nextTransitionTime())
      .map(value => zio.aws.ssm.model.primitives.ISO8601String(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetCalendarStateResponse
  ): zio.aws.ssm.model.GetCalendarStateResponse.ReadOnly = new Wrapper(impl)
}
