package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  DocumentDisplayName,
  DocumentName,
  DocumentVersion,
  DateTime,
  DocumentStatusInformation,
  DocumentVersionName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DocumentVersionInfo(
    name: Option[DocumentName] = None,
    displayName: Option[DocumentDisplayName] = None,
    documentVersion: Option[DocumentVersion] = None,
    versionName: Option[DocumentVersionName] = None,
    createdDate: Option[DateTime] = None,
    isDefaultVersion: Option[Boolean] = None,
    documentFormat: Option[zio.aws.ssm.model.DocumentFormat] = None,
    status: Option[zio.aws.ssm.model.DocumentStatus] = None,
    statusInformation: Option[DocumentStatusInformation] = None,
    reviewStatus: Option[zio.aws.ssm.model.ReviewStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DocumentVersionInfo = {
    import DocumentVersionInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DocumentVersionInfo
      .builder()
      .optionallyWith(
        name.map(value => DocumentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        displayName.map(value =>
          DocumentDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        versionName.map(value =>
          DocumentVersionName.unwrap(value): java.lang.String
        )
      )(_.versionName)
      .optionallyWith(
        createdDate.map(value => DateTime.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(isDefaultVersion.map(value => value: java.lang.Boolean))(
        _.isDefaultVersion
      )
      .optionallyWith(documentFormat.map(value => value.unwrap))(
        _.documentFormat
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusInformation.map(value =>
          DocumentStatusInformation.unwrap(value): java.lang.String
        )
      )(_.statusInformation)
      .optionallyWith(reviewStatus.map(value => value.unwrap))(_.reviewStatus)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DocumentVersionInfo.ReadOnly =
    zio.aws.ssm.model.DocumentVersionInfo.wrap(buildAwsValue())
}
object DocumentVersionInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DocumentVersionInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DocumentVersionInfo =
      zio.aws.ssm.model.DocumentVersionInfo(
        name.map(value => value),
        displayName.map(value => value),
        documentVersion.map(value => value),
        versionName.map(value => value),
        createdDate.map(value => value),
        isDefaultVersion.map(value => value),
        documentFormat.map(value => value),
        status.map(value => value),
        statusInformation.map(value => value),
        reviewStatus.map(value => value)
      )
    def name: Option[DocumentName]
    def displayName: Option[DocumentDisplayName]
    def documentVersion: Option[DocumentVersion]
    def versionName: Option[DocumentVersionName]
    def createdDate: Option[DateTime]
    def isDefaultVersion: Option[Boolean]
    def documentFormat: Option[zio.aws.ssm.model.DocumentFormat]
    def status: Option[zio.aws.ssm.model.DocumentStatus]
    def statusInformation: Option[DocumentStatusInformation]
    def reviewStatus: Option[zio.aws.ssm.model.ReviewStatus]
    def getName: ZIO[Any, AwsError, DocumentName] =
      AwsError.unwrapOptionField("name", name)
    def getDisplayName: ZIO[Any, AwsError, DocumentDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getVersionName: ZIO[Any, AwsError, DocumentVersionName] =
      AwsError.unwrapOptionField("versionName", versionName)
    def getCreatedDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getIsDefaultVersion: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefaultVersion", isDefaultVersion)
    def getDocumentFormat
        : ZIO[Any, AwsError, zio.aws.ssm.model.DocumentFormat] =
      AwsError.unwrapOptionField("documentFormat", documentFormat)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssm.model.DocumentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusInformation: ZIO[Any, AwsError, DocumentStatusInformation] =
      AwsError.unwrapOptionField("statusInformation", statusInformation)
    def getReviewStatus: ZIO[Any, AwsError, zio.aws.ssm.model.ReviewStatus] =
      AwsError.unwrapOptionField("reviewStatus", reviewStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DocumentVersionInfo
  ) extends zio.aws.ssm.model.DocumentVersionInfo.ReadOnly {
    override val name: Option[DocumentName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.DocumentName(value))
    override val displayName: Option[DocumentDisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.ssm.model.primitives.DocumentDisplayName(value))
    override val documentVersion: Option[DocumentVersion] = scala
      .Option(impl.documentVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val versionName: Option[DocumentVersionName] = scala
      .Option(impl.versionName())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersionName(value))
    override val createdDate: Option[DateTime] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val isDefaultVersion: Option[Boolean] =
      scala.Option(impl.isDefaultVersion()).map(value => value: Boolean)
    override val documentFormat: Option[zio.aws.ssm.model.DocumentFormat] =
      scala
        .Option(impl.documentFormat())
        .map(value => zio.aws.ssm.model.DocumentFormat.wrap(value))
    override val status: Option[zio.aws.ssm.model.DocumentStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.ssm.model.DocumentStatus.wrap(value))
    override val statusInformation: Option[DocumentStatusInformation] = scala
      .Option(impl.statusInformation())
      .map(value =>
        zio.aws.ssm.model.primitives.DocumentStatusInformation(value)
      )
    override val reviewStatus: Option[zio.aws.ssm.model.ReviewStatus] = scala
      .Option(impl.reviewStatus())
      .map(value => zio.aws.ssm.model.ReviewStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DocumentVersionInfo
  ): zio.aws.ssm.model.DocumentVersionInfo.ReadOnly = new Wrapper(impl)
}
