package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait AutomationSubtype {
  def unwrap: software.amazon.awssdk.services.ssm.model.AutomationSubtype
}
object AutomationSubtype {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.AutomationSubtype
  ): zio.aws.ssm.model.AutomationSubtype = value match {
    case software.amazon.awssdk.services.ssm.model.AutomationSubtype.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.AutomationSubtype.CHANGE_REQUEST =>
      val r = ChangeRequest
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.AutomationSubtype {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationSubtype =
      software.amazon.awssdk.services.ssm.model.AutomationSubtype.UNKNOWN_TO_SDK_VERSION
  }
  case object ChangeRequest extends zio.aws.ssm.model.AutomationSubtype {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AutomationSubtype =
      software.amazon.awssdk.services.ssm.model.AutomationSubtype.CHANGE_REQUEST
  }
}
