package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  LastResourceDataSyncTime,
  ResourceDataSyncCreatedTime,
  ResourceDataSyncLastModifiedTime,
  LastResourceDataSyncMessage,
  ResourceDataSyncType,
  ResourceDataSyncName,
  LastSuccessfulResourceDataSyncTime
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ResourceDataSyncItem(
    syncName: Option[ResourceDataSyncName] = None,
    syncType: Option[ResourceDataSyncType] = None,
    syncSource: Option[zio.aws.ssm.model.ResourceDataSyncSourceWithState] =
      None,
    s3Destination: Option[zio.aws.ssm.model.ResourceDataSyncS3Destination] =
      None,
    lastSyncTime: Option[LastResourceDataSyncTime] = None,
    lastSuccessfulSyncTime: Option[LastSuccessfulResourceDataSyncTime] = None,
    syncLastModifiedTime: Option[ResourceDataSyncLastModifiedTime] = None,
    lastStatus: Option[zio.aws.ssm.model.LastResourceDataSyncStatus] = None,
    syncCreatedTime: Option[ResourceDataSyncCreatedTime] = None,
    lastSyncStatusMessage: Option[LastResourceDataSyncMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ResourceDataSyncItem = {
    import ResourceDataSyncItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ResourceDataSyncItem
      .builder()
      .optionallyWith(
        syncName.map(value =>
          ResourceDataSyncName.unwrap(value): java.lang.String
        )
      )(_.syncName)
      .optionallyWith(
        syncType.map(value =>
          ResourceDataSyncType.unwrap(value): java.lang.String
        )
      )(_.syncType)
      .optionallyWith(syncSource.map(value => value.buildAwsValue()))(
        _.syncSource
      )
      .optionallyWith(s3Destination.map(value => value.buildAwsValue()))(
        _.s3Destination
      )
      .optionallyWith(
        lastSyncTime.map(value =>
          LastResourceDataSyncTime.unwrap(value): Instant
        )
      )(_.lastSyncTime)
      .optionallyWith(
        lastSuccessfulSyncTime.map(value =>
          LastSuccessfulResourceDataSyncTime.unwrap(value): Instant
        )
      )(_.lastSuccessfulSyncTime)
      .optionallyWith(
        syncLastModifiedTime.map(value =>
          ResourceDataSyncLastModifiedTime.unwrap(value): Instant
        )
      )(_.syncLastModifiedTime)
      .optionallyWith(lastStatus.map(value => value.unwrap))(_.lastStatus)
      .optionallyWith(
        syncCreatedTime.map(value =>
          ResourceDataSyncCreatedTime.unwrap(value): Instant
        )
      )(_.syncCreatedTime)
      .optionallyWith(
        lastSyncStatusMessage.map(value =>
          LastResourceDataSyncMessage.unwrap(value): java.lang.String
        )
      )(_.lastSyncStatusMessage)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ResourceDataSyncItem.ReadOnly =
    zio.aws.ssm.model.ResourceDataSyncItem.wrap(buildAwsValue())
}
object ResourceDataSyncItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ResourceDataSyncItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ResourceDataSyncItem =
      zio.aws.ssm.model.ResourceDataSyncItem(
        syncName.map(value => value),
        syncType.map(value => value),
        syncSource.map(value => value.asEditable),
        s3Destination.map(value => value.asEditable),
        lastSyncTime.map(value => value),
        lastSuccessfulSyncTime.map(value => value),
        syncLastModifiedTime.map(value => value),
        lastStatus.map(value => value),
        syncCreatedTime.map(value => value),
        lastSyncStatusMessage.map(value => value)
      )
    def syncName: Option[ResourceDataSyncName]
    def syncType: Option[ResourceDataSyncType]
    def syncSource
        : Option[zio.aws.ssm.model.ResourceDataSyncSourceWithState.ReadOnly]
    def s3Destination
        : Option[zio.aws.ssm.model.ResourceDataSyncS3Destination.ReadOnly]
    def lastSyncTime: Option[LastResourceDataSyncTime]
    def lastSuccessfulSyncTime: Option[LastSuccessfulResourceDataSyncTime]
    def syncLastModifiedTime: Option[ResourceDataSyncLastModifiedTime]
    def lastStatus: Option[zio.aws.ssm.model.LastResourceDataSyncStatus]
    def syncCreatedTime: Option[ResourceDataSyncCreatedTime]
    def lastSyncStatusMessage: Option[LastResourceDataSyncMessage]
    def getSyncName: ZIO[Any, AwsError, ResourceDataSyncName] =
      AwsError.unwrapOptionField("syncName", syncName)
    def getSyncType: ZIO[Any, AwsError, ResourceDataSyncType] =
      AwsError.unwrapOptionField("syncType", syncType)
    def getSyncSource: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.ResourceDataSyncSourceWithState.ReadOnly
    ] = AwsError.unwrapOptionField("syncSource", syncSource)
    def getS3Destination: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.ResourceDataSyncS3Destination.ReadOnly
    ] = AwsError.unwrapOptionField("s3Destination", s3Destination)
    def getLastSyncTime: ZIO[Any, AwsError, LastResourceDataSyncTime] =
      AwsError.unwrapOptionField("lastSyncTime", lastSyncTime)
    def getLastSuccessfulSyncTime
        : ZIO[Any, AwsError, LastSuccessfulResourceDataSyncTime] = AwsError
      .unwrapOptionField("lastSuccessfulSyncTime", lastSuccessfulSyncTime)
    def getSyncLastModifiedTime
        : ZIO[Any, AwsError, ResourceDataSyncLastModifiedTime] =
      AwsError.unwrapOptionField("syncLastModifiedTime", syncLastModifiedTime)
    def getLastStatus
        : ZIO[Any, AwsError, zio.aws.ssm.model.LastResourceDataSyncStatus] =
      AwsError.unwrapOptionField("lastStatus", lastStatus)
    def getSyncCreatedTime: ZIO[Any, AwsError, ResourceDataSyncCreatedTime] =
      AwsError.unwrapOptionField("syncCreatedTime", syncCreatedTime)
    def getLastSyncStatusMessage
        : ZIO[Any, AwsError, LastResourceDataSyncMessage] =
      AwsError.unwrapOptionField("lastSyncStatusMessage", lastSyncStatusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ResourceDataSyncItem
  ) extends zio.aws.ssm.model.ResourceDataSyncItem.ReadOnly {
    override val syncName: Option[ResourceDataSyncName] = scala
      .Option(impl.syncName())
      .map(value => zio.aws.ssm.model.primitives.ResourceDataSyncName(value))
    override val syncType: Option[ResourceDataSyncType] = scala
      .Option(impl.syncType())
      .map(value => zio.aws.ssm.model.primitives.ResourceDataSyncType(value))
    override val syncSource
        : Option[zio.aws.ssm.model.ResourceDataSyncSourceWithState.ReadOnly] =
      scala
        .Option(impl.syncSource())
        .map(value =>
          zio.aws.ssm.model.ResourceDataSyncSourceWithState.wrap(value)
        )
    override val s3Destination
        : Option[zio.aws.ssm.model.ResourceDataSyncS3Destination.ReadOnly] =
      scala
        .Option(impl.s3Destination())
        .map(value =>
          zio.aws.ssm.model.ResourceDataSyncS3Destination.wrap(value)
        )
    override val lastSyncTime: Option[LastResourceDataSyncTime] = scala
      .Option(impl.lastSyncTime())
      .map(value =>
        zio.aws.ssm.model.primitives.LastResourceDataSyncTime(value)
      )
    override val lastSuccessfulSyncTime
        : Option[LastSuccessfulResourceDataSyncTime] = scala
      .Option(impl.lastSuccessfulSyncTime())
      .map(value =>
        zio.aws.ssm.model.primitives.LastSuccessfulResourceDataSyncTime(value)
      )
    override val syncLastModifiedTime
        : Option[ResourceDataSyncLastModifiedTime] = scala
      .Option(impl.syncLastModifiedTime())
      .map(value =>
        zio.aws.ssm.model.primitives.ResourceDataSyncLastModifiedTime(value)
      )
    override val lastStatus
        : Option[zio.aws.ssm.model.LastResourceDataSyncStatus] = scala
      .Option(impl.lastStatus())
      .map(value => zio.aws.ssm.model.LastResourceDataSyncStatus.wrap(value))
    override val syncCreatedTime: Option[ResourceDataSyncCreatedTime] = scala
      .Option(impl.syncCreatedTime())
      .map(value =>
        zio.aws.ssm.model.primitives.ResourceDataSyncCreatedTime(value)
      )
    override val lastSyncStatusMessage: Option[LastResourceDataSyncMessage] =
      scala
        .Option(impl.lastSyncStatusMessage())
        .map(value =>
          zio.aws.ssm.model.primitives.LastResourceDataSyncMessage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ResourceDataSyncItem
  ): zio.aws.ssm.model.ResourceDataSyncItem.ReadOnly = new Wrapper(impl)
}
