package zio.aws.ssm.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  PatchInstalledPendingRebootCount,
  PatchUnreportedNotApplicableCount,
  PatchInstalledOtherCount,
  PatchInstalledRejectedCount,
  PatchInstalledCount,
  OwnerInformation,
  InstanceId,
  PatchNotApplicableCount,
  InstallOverrideList,
  PatchSecurityNonCompliantCount,
  DateTime,
  PatchCriticalNonCompliantCount,
  PatchFailedCount,
  BaselineId,
  PatchOtherNonCompliantCount,
  SnapshotId,
  PatchGroup,
  PatchMissingCount
}
import scala.jdk.CollectionConverters._
final case class InstancePatchState(
    instanceId: InstanceId,
    patchGroup: PatchGroup,
    baselineId: BaselineId,
    snapshotId: Option[SnapshotId] = None,
    installOverrideList: Option[InstallOverrideList] = None,
    ownerInformation: Option[OwnerInformation] = None,
    installedCount: Option[PatchInstalledCount] = None,
    installedOtherCount: Option[PatchInstalledOtherCount] = None,
    installedPendingRebootCount: Option[PatchInstalledPendingRebootCount] =
      None,
    installedRejectedCount: Option[PatchInstalledRejectedCount] = None,
    missingCount: Option[PatchMissingCount] = None,
    failedCount: Option[PatchFailedCount] = None,
    unreportedNotApplicableCount: Option[PatchUnreportedNotApplicableCount] =
      None,
    notApplicableCount: Option[PatchNotApplicableCount] = None,
    operationStartTime: DateTime,
    operationEndTime: DateTime,
    operation: zio.aws.ssm.model.PatchOperationType,
    lastNoRebootInstallOperationTime: Option[DateTime] = None,
    rebootOption: Option[zio.aws.ssm.model.RebootOption] = None,
    criticalNonCompliantCount: Option[PatchCriticalNonCompliantCount] = None,
    securityNonCompliantCount: Option[PatchSecurityNonCompliantCount] = None,
    otherNonCompliantCount: Option[PatchOtherNonCompliantCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InstancePatchState = {
    import InstancePatchState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InstancePatchState
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .patchGroup(PatchGroup.unwrap(patchGroup): java.lang.String)
      .baselineId(BaselineId.unwrap(baselineId): java.lang.String)
      .optionallyWith(
        snapshotId.map(value => SnapshotId.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(
        installOverrideList.map(value =>
          InstallOverrideList.unwrap(value): java.lang.String
        )
      )(_.installOverrideList)
      .optionallyWith(
        ownerInformation.map(value =>
          OwnerInformation.unwrap(value): java.lang.String
        )
      )(_.ownerInformation)
      .optionallyWith(
        installedCount.map(value => PatchInstalledCount.unwrap(value): Integer)
      )(_.installedCount)
      .optionallyWith(
        installedOtherCount.map(value =>
          PatchInstalledOtherCount.unwrap(value): Integer
        )
      )(_.installedOtherCount)
      .optionallyWith(
        installedPendingRebootCount.map(value =>
          PatchInstalledPendingRebootCount.unwrap(value): Integer
        )
      )(_.installedPendingRebootCount)
      .optionallyWith(
        installedRejectedCount.map(value =>
          PatchInstalledRejectedCount.unwrap(value): Integer
        )
      )(_.installedRejectedCount)
      .optionallyWith(
        missingCount.map(value => PatchMissingCount.unwrap(value): Integer)
      )(_.missingCount)
      .optionallyWith(
        failedCount.map(value => PatchFailedCount.unwrap(value): Integer)
      )(_.failedCount)
      .optionallyWith(
        unreportedNotApplicableCount.map(value =>
          PatchUnreportedNotApplicableCount.unwrap(value): Integer
        )
      )(_.unreportedNotApplicableCount)
      .optionallyWith(
        notApplicableCount.map(value =>
          PatchNotApplicableCount.unwrap(value): Integer
        )
      )(_.notApplicableCount)
      .operationStartTime(DateTime.unwrap(operationStartTime): Instant)
      .operationEndTime(DateTime.unwrap(operationEndTime): Instant)
      .operation(operation.unwrap)
      .optionallyWith(
        lastNoRebootInstallOperationTime.map(value =>
          DateTime.unwrap(value): Instant
        )
      )(_.lastNoRebootInstallOperationTime)
      .optionallyWith(rebootOption.map(value => value.unwrap))(_.rebootOption)
      .optionallyWith(
        criticalNonCompliantCount.map(value =>
          PatchCriticalNonCompliantCount.unwrap(value): Integer
        )
      )(_.criticalNonCompliantCount)
      .optionallyWith(
        securityNonCompliantCount.map(value =>
          PatchSecurityNonCompliantCount.unwrap(value): Integer
        )
      )(_.securityNonCompliantCount)
      .optionallyWith(
        otherNonCompliantCount.map(value =>
          PatchOtherNonCompliantCount.unwrap(value): Integer
        )
      )(_.otherNonCompliantCount)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InstancePatchState.ReadOnly =
    zio.aws.ssm.model.InstancePatchState.wrap(buildAwsValue())
}
object InstancePatchState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InstancePatchState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InstancePatchState =
      zio.aws.ssm.model.InstancePatchState(
        instanceId,
        patchGroup,
        baselineId,
        snapshotId.map(value => value),
        installOverrideList.map(value => value),
        ownerInformation.map(value => value),
        installedCount.map(value => value),
        installedOtherCount.map(value => value),
        installedPendingRebootCount.map(value => value),
        installedRejectedCount.map(value => value),
        missingCount.map(value => value),
        failedCount.map(value => value),
        unreportedNotApplicableCount.map(value => value),
        notApplicableCount.map(value => value),
        operationStartTime,
        operationEndTime,
        operation,
        lastNoRebootInstallOperationTime.map(value => value),
        rebootOption.map(value => value),
        criticalNonCompliantCount.map(value => value),
        securityNonCompliantCount.map(value => value),
        otherNonCompliantCount.map(value => value)
      )
    def instanceId: InstanceId
    def patchGroup: PatchGroup
    def baselineId: BaselineId
    def snapshotId: Option[SnapshotId]
    def installOverrideList: Option[InstallOverrideList]
    def ownerInformation: Option[OwnerInformation]
    def installedCount: Option[PatchInstalledCount]
    def installedOtherCount: Option[PatchInstalledOtherCount]
    def installedPendingRebootCount: Option[PatchInstalledPendingRebootCount]
    def installedRejectedCount: Option[PatchInstalledRejectedCount]
    def missingCount: Option[PatchMissingCount]
    def failedCount: Option[PatchFailedCount]
    def unreportedNotApplicableCount: Option[PatchUnreportedNotApplicableCount]
    def notApplicableCount: Option[PatchNotApplicableCount]
    def operationStartTime: DateTime
    def operationEndTime: DateTime
    def operation: zio.aws.ssm.model.PatchOperationType
    def lastNoRebootInstallOperationTime: Option[DateTime]
    def rebootOption: Option[zio.aws.ssm.model.RebootOption]
    def criticalNonCompliantCount: Option[PatchCriticalNonCompliantCount]
    def securityNonCompliantCount: Option[PatchSecurityNonCompliantCount]
    def otherNonCompliantCount: Option[PatchOtherNonCompliantCount]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getPatchGroup: ZIO[Any, Nothing, PatchGroup] = ZIO.succeed(patchGroup)
    def getBaselineId: ZIO[Any, Nothing, BaselineId] = ZIO.succeed(baselineId)
    def getSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getInstallOverrideList: ZIO[Any, AwsError, InstallOverrideList] =
      AwsError.unwrapOptionField("installOverrideList", installOverrideList)
    def getOwnerInformation: ZIO[Any, AwsError, OwnerInformation] =
      AwsError.unwrapOptionField("ownerInformation", ownerInformation)
    def getInstalledCount: ZIO[Any, AwsError, PatchInstalledCount] =
      AwsError.unwrapOptionField("installedCount", installedCount)
    def getInstalledOtherCount: ZIO[Any, AwsError, PatchInstalledOtherCount] =
      AwsError.unwrapOptionField("installedOtherCount", installedOtherCount)
    def getInstalledPendingRebootCount
        : ZIO[Any, AwsError, PatchInstalledPendingRebootCount] =
      AwsError.unwrapOptionField(
        "installedPendingRebootCount",
        installedPendingRebootCount
      )
    def getInstalledRejectedCount
        : ZIO[Any, AwsError, PatchInstalledRejectedCount] = AwsError
      .unwrapOptionField("installedRejectedCount", installedRejectedCount)
    def getMissingCount: ZIO[Any, AwsError, PatchMissingCount] =
      AwsError.unwrapOptionField("missingCount", missingCount)
    def getFailedCount: ZIO[Any, AwsError, PatchFailedCount] =
      AwsError.unwrapOptionField("failedCount", failedCount)
    def getUnreportedNotApplicableCount
        : ZIO[Any, AwsError, PatchUnreportedNotApplicableCount] =
      AwsError.unwrapOptionField(
        "unreportedNotApplicableCount",
        unreportedNotApplicableCount
      )
    def getNotApplicableCount: ZIO[Any, AwsError, PatchNotApplicableCount] =
      AwsError.unwrapOptionField("notApplicableCount", notApplicableCount)
    def getOperationStartTime: ZIO[Any, Nothing, DateTime] =
      ZIO.succeed(operationStartTime)
    def getOperationEndTime: ZIO[Any, Nothing, DateTime] =
      ZIO.succeed(operationEndTime)
    def getOperation: ZIO[Any, Nothing, zio.aws.ssm.model.PatchOperationType] =
      ZIO.succeed(operation)
    def getLastNoRebootInstallOperationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField(
        "lastNoRebootInstallOperationTime",
        lastNoRebootInstallOperationTime
      )
    def getRebootOption: ZIO[Any, AwsError, zio.aws.ssm.model.RebootOption] =
      AwsError.unwrapOptionField("rebootOption", rebootOption)
    def getCriticalNonCompliantCount
        : ZIO[Any, AwsError, PatchCriticalNonCompliantCount] = AwsError
      .unwrapOptionField("criticalNonCompliantCount", criticalNonCompliantCount)
    def getSecurityNonCompliantCount
        : ZIO[Any, AwsError, PatchSecurityNonCompliantCount] = AwsError
      .unwrapOptionField("securityNonCompliantCount", securityNonCompliantCount)
    def getOtherNonCompliantCount
        : ZIO[Any, AwsError, PatchOtherNonCompliantCount] = AwsError
      .unwrapOptionField("otherNonCompliantCount", otherNonCompliantCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InstancePatchState
  ) extends zio.aws.ssm.model.InstancePatchState.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ssm.model.primitives.InstanceId(impl.instanceId())
    override val patchGroup: PatchGroup =
      zio.aws.ssm.model.primitives.PatchGroup(impl.patchGroup())
    override val baselineId: BaselineId =
      zio.aws.ssm.model.primitives.BaselineId(impl.baselineId())
    override val snapshotId: Option[SnapshotId] = scala
      .Option(impl.snapshotId())
      .map(value => zio.aws.ssm.model.primitives.SnapshotId(value))
    override val installOverrideList: Option[InstallOverrideList] = scala
      .Option(impl.installOverrideList())
      .map(value => zio.aws.ssm.model.primitives.InstallOverrideList(value))
    override val ownerInformation: Option[OwnerInformation] = scala
      .Option(impl.ownerInformation())
      .map(value => zio.aws.ssm.model.primitives.OwnerInformation(value))
    override val installedCount: Option[PatchInstalledCount] = scala
      .Option(impl.installedCount())
      .map(value => zio.aws.ssm.model.primitives.PatchInstalledCount(value))
    override val installedOtherCount: Option[PatchInstalledOtherCount] = scala
      .Option(impl.installedOtherCount())
      .map(value =>
        zio.aws.ssm.model.primitives.PatchInstalledOtherCount(value)
      )
    override val installedPendingRebootCount
        : Option[PatchInstalledPendingRebootCount] = scala
      .Option(impl.installedPendingRebootCount())
      .map(value =>
        zio.aws.ssm.model.primitives.PatchInstalledPendingRebootCount(value)
      )
    override val installedRejectedCount: Option[PatchInstalledRejectedCount] =
      scala
        .Option(impl.installedRejectedCount())
        .map(value =>
          zio.aws.ssm.model.primitives.PatchInstalledRejectedCount(value)
        )
    override val missingCount: Option[PatchMissingCount] = scala
      .Option(impl.missingCount())
      .map(value => zio.aws.ssm.model.primitives.PatchMissingCount(value))
    override val failedCount: Option[PatchFailedCount] = scala
      .Option(impl.failedCount())
      .map(value => zio.aws.ssm.model.primitives.PatchFailedCount(value))
    override val unreportedNotApplicableCount
        : Option[PatchUnreportedNotApplicableCount] = scala
      .Option(impl.unreportedNotApplicableCount())
      .map(value =>
        zio.aws.ssm.model.primitives.PatchUnreportedNotApplicableCount(value)
      )
    override val notApplicableCount: Option[PatchNotApplicableCount] = scala
      .Option(impl.notApplicableCount())
      .map(value => zio.aws.ssm.model.primitives.PatchNotApplicableCount(value))
    override val operationStartTime: DateTime =
      zio.aws.ssm.model.primitives.DateTime(impl.operationStartTime())
    override val operationEndTime: DateTime =
      zio.aws.ssm.model.primitives.DateTime(impl.operationEndTime())
    override val operation: zio.aws.ssm.model.PatchOperationType =
      zio.aws.ssm.model.PatchOperationType.wrap(impl.operation())
    override val lastNoRebootInstallOperationTime: Option[DateTime] = scala
      .Option(impl.lastNoRebootInstallOperationTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val rebootOption: Option[zio.aws.ssm.model.RebootOption] = scala
      .Option(impl.rebootOption())
      .map(value => zio.aws.ssm.model.RebootOption.wrap(value))
    override val criticalNonCompliantCount
        : Option[PatchCriticalNonCompliantCount] = scala
      .Option(impl.criticalNonCompliantCount())
      .map(value =>
        zio.aws.ssm.model.primitives.PatchCriticalNonCompliantCount(value)
      )
    override val securityNonCompliantCount
        : Option[PatchSecurityNonCompliantCount] = scala
      .Option(impl.securityNonCompliantCount())
      .map(value =>
        zio.aws.ssm.model.primitives.PatchSecurityNonCompliantCount(value)
      )
    override val otherNonCompliantCount: Option[PatchOtherNonCompliantCount] =
      scala
        .Option(impl.otherNonCompliantCount())
        .map(value =>
          zio.aws.ssm.model.primitives.PatchOtherNonCompliantCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InstancePatchState
  ): zio.aws.ssm.model.InstancePatchState.ReadOnly = new Wrapper(impl)
}
