package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEffectiveInstanceAssociationsResponse(
    associations: Option[Iterable[zio.aws.ssm.model.InstanceAssociation]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse = {
    import DescribeEffectiveInstanceAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse
      .builder()
      .optionallyWith(
        associations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsResponse.ReadOnly =
    zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsResponse
      .wrap(buildAwsValue())
}
object DescribeEffectiveInstanceAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsResponse =
      zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsResponse(
        associations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def associations
        : Option[List[zio.aws.ssm.model.InstanceAssociation.ReadOnly]]
    def nextToken: Option[NextToken]
    def getAssociations: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.InstanceAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("associations", associations)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse
  ) extends zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsResponse.ReadOnly {
    override val associations
        : Option[List[zio.aws.ssm.model.InstanceAssociation.ReadOnly]] = scala
      .Option(impl.associations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.InstanceAssociation.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse
  ): zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
