package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  SessionTarget,
  SessionReason,
  DocumentARN,
  SessionManagerParameterName,
  SessionManagerParameterValue
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartSessionRequest(
    target: SessionTarget,
    documentName: Option[DocumentARN] = None,
    reason: Option[SessionReason] = None,
    parameters: Option[
      Map[SessionManagerParameterName, Iterable[SessionManagerParameterValue]]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.StartSessionRequest = {
    import StartSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.StartSessionRequest
      .builder()
      .target(SessionTarget.unwrap(target): java.lang.String)
      .optionallyWith(
        documentName.map(value => DocumentARN.unwrap(value): java.lang.String)
      )(_.documentName)
      .optionallyWith(
        reason.map(value => SessionReason.unwrap(value): java.lang.String)
      )(_.reason)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (SessionManagerParameterName
                .unwrap(key): java.lang.String) -> value.map { item =>
                SessionManagerParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.StartSessionRequest.ReadOnly =
    zio.aws.ssm.model.StartSessionRequest.wrap(buildAwsValue())
}
object StartSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.StartSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.StartSessionRequest =
      zio.aws.ssm.model.StartSessionRequest(
        target,
        documentName.map(value => value),
        reason.map(value => value),
        parameters.map(value => value)
      )
    def target: SessionTarget
    def documentName: Option[DocumentARN]
    def reason: Option[SessionReason]
    def parameters: Option[
      Map[SessionManagerParameterName, List[SessionManagerParameterValue]]
    ]
    def getTarget: ZIO[Any, Nothing, SessionTarget] = ZIO.succeed(target)
    def getDocumentName: ZIO[Any, AwsError, DocumentARN] =
      AwsError.unwrapOptionField("documentName", documentName)
    def getReason: ZIO[Any, AwsError, SessionReason] =
      AwsError.unwrapOptionField("reason", reason)
    def getParameters: ZIO[Any, AwsError, Map[SessionManagerParameterName, List[
      SessionManagerParameterValue
    ]]] = AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.StartSessionRequest
  ) extends zio.aws.ssm.model.StartSessionRequest.ReadOnly {
    override val target: SessionTarget =
      zio.aws.ssm.model.primitives.SessionTarget(impl.target())
    override val documentName: Option[DocumentARN] = scala
      .Option(impl.documentName())
      .map(value => zio.aws.ssm.model.primitives.DocumentARN(value))
    override val reason: Option[SessionReason] = scala
      .Option(impl.reason())
      .map(value => zio.aws.ssm.model.primitives.SessionReason(value))
    override val parameters: Option[
      Map[SessionManagerParameterName, List[SessionManagerParameterValue]]
    ] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives
              .SessionManagerParameterName(key) -> value.asScala.map { item =>
              zio.aws.ssm.model.primitives.SessionManagerParameterValue(item)
            }.toList
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.StartSessionRequest
  ): zio.aws.ssm.model.StartSessionRequest.ReadOnly = new Wrapper(impl)
}
