package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{NextToken, MaxResults, AssociationId}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAssociationVersionsRequest(
    associationId: AssociationId,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest = {
    import ListAssociationVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest
      .builder()
      .associationId(AssociationId.unwrap(associationId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListAssociationVersionsRequest.ReadOnly =
    zio.aws.ssm.model.ListAssociationVersionsRequest.wrap(buildAwsValue())
}
object ListAssociationVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListAssociationVersionsRequest =
      zio.aws.ssm.model.ListAssociationVersionsRequest(
        associationId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def associationId: AssociationId
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getAssociationId: ZIO[Any, Nothing, AssociationId] =
      ZIO.succeed(associationId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest
  ) extends zio.aws.ssm.model.ListAssociationVersionsRequest.ReadOnly {
    override val associationId: AssociationId =
      zio.aws.ssm.model.primitives.AssociationId(impl.associationId())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest
  ): zio.aws.ssm.model.ListAssociationVersionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
