package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeMaintenanceWindowExecutionsResponse(
    windowExecutions: Option[
      Iterable[zio.aws.ssm.model.MaintenanceWindowExecution]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse = {
    import DescribeMaintenanceWindowExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse
      .builder()
      .optionallyWith(
        windowExecutions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.windowExecutions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeMaintenanceWindowExecutionsResponse.ReadOnly =
    zio.aws.ssm.model.DescribeMaintenanceWindowExecutionsResponse
      .wrap(buildAwsValue())
}
object DescribeMaintenanceWindowExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DescribeMaintenanceWindowExecutionsResponse =
      zio.aws.ssm.model.DescribeMaintenanceWindowExecutionsResponse(
        windowExecutions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def windowExecutions
        : Option[List[zio.aws.ssm.model.MaintenanceWindowExecution.ReadOnly]]
    def nextToken: Option[NextToken]
    def getWindowExecutions: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.MaintenanceWindowExecution.ReadOnly
    ]] = AwsError.unwrapOptionField("windowExecutions", windowExecutions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse
  ) extends zio.aws.ssm.model.DescribeMaintenanceWindowExecutionsResponse.ReadOnly {
    override val windowExecutions
        : Option[List[zio.aws.ssm.model.MaintenanceWindowExecution.ReadOnly]] =
      scala
        .Option(impl.windowExecutions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.MaintenanceWindowExecution.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse
  ): zio.aws.ssm.model.DescribeMaintenanceWindowExecutionsResponse.ReadOnly =
    new Wrapper(impl)
}
