package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  DocumentVersionName,
  DocumentVersion,
  DocumentARN
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDocumentRequest(
    name: DocumentARN,
    documentVersion: Option[DocumentVersion] = None,
    versionName: Option[DocumentVersionName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeDocumentRequest = {
    import DescribeDocumentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeDocumentRequest
      .builder()
      .name(DocumentARN.unwrap(name): java.lang.String)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        versionName.map(value =>
          DocumentVersionName.unwrap(value): java.lang.String
        )
      )(_.versionName)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribeDocumentRequest.ReadOnly =
    zio.aws.ssm.model.DescribeDocumentRequest.wrap(buildAwsValue())
}
object DescribeDocumentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeDocumentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeDocumentRequest =
      zio.aws.ssm.model.DescribeDocumentRequest(
        name,
        documentVersion.map(value => value),
        versionName.map(value => value)
      )
    def name: DocumentARN
    def documentVersion: Option[DocumentVersion]
    def versionName: Option[DocumentVersionName]
    def getName: ZIO[Any, Nothing, DocumentARN] = ZIO.succeed(name)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getVersionName: ZIO[Any, AwsError, DocumentVersionName] =
      AwsError.unwrapOptionField("versionName", versionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeDocumentRequest
  ) extends zio.aws.ssm.model.DescribeDocumentRequest.ReadOnly {
    override val name: DocumentARN =
      zio.aws.ssm.model.primitives.DocumentARN(impl.name())
    override val documentVersion: Option[DocumentVersion] = scala
      .Option(impl.documentVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val versionName: Option[DocumentVersionName] = scala
      .Option(impl.versionName())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersionName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeDocumentRequest
  ): zio.aws.ssm.model.DescribeDocumentRequest.ReadOnly = new Wrapper(impl)
}
