package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  AssociationId,
  DocumentARN,
  ScheduleExpression,
  InstanceId,
  AssociationName,
  DocumentVersion,
  DateTime,
  AssociationVersion
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Association(
    name: Option[DocumentARN] = None,
    instanceId: Option[InstanceId] = None,
    associationId: Option[AssociationId] = None,
    associationVersion: Option[AssociationVersion] = None,
    documentVersion: Option[DocumentVersion] = None,
    targets: Option[Iterable[zio.aws.ssm.model.Target]] = None,
    lastExecutionDate: Option[DateTime] = None,
    overview: Option[zio.aws.ssm.model.AssociationOverview] = None,
    scheduleExpression: Option[ScheduleExpression] = None,
    associationName: Option[AssociationName] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.Association = {
    import Association.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.Association
      .builder()
      .optionallyWith(
        name.map(value => DocumentARN.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        associationId.map(value =>
          AssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        associationVersion.map(value =>
          AssociationVersion.unwrap(value): java.lang.String
        )
      )(_.associationVersion)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        lastExecutionDate.map(value => DateTime.unwrap(value): Instant)
      )(_.lastExecutionDate)
      .optionallyWith(overview.map(value => value.buildAwsValue()))(_.overview)
      .optionallyWith(
        scheduleExpression.map(value =>
          ScheduleExpression.unwrap(value): java.lang.String
        )
      )(_.scheduleExpression)
      .optionallyWith(
        associationName.map(value =>
          AssociationName.unwrap(value): java.lang.String
        )
      )(_.associationName)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.Association.ReadOnly =
    zio.aws.ssm.model.Association.wrap(buildAwsValue())
}
object Association {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.Association] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.Association =
      zio.aws.ssm.model.Association(
        name.map(value => value),
        instanceId.map(value => value),
        associationId.map(value => value),
        associationVersion.map(value => value),
        documentVersion.map(value => value),
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastExecutionDate.map(value => value),
        overview.map(value => value.asEditable),
        scheduleExpression.map(value => value),
        associationName.map(value => value)
      )
    def name: Option[DocumentARN]
    def instanceId: Option[InstanceId]
    def associationId: Option[AssociationId]
    def associationVersion: Option[AssociationVersion]
    def documentVersion: Option[DocumentVersion]
    def targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]]
    def lastExecutionDate: Option[DateTime]
    def overview: Option[zio.aws.ssm.model.AssociationOverview.ReadOnly]
    def scheduleExpression: Option[ScheduleExpression]
    def associationName: Option[AssociationName]
    def getName: ZIO[Any, AwsError, DocumentARN] =
      AwsError.unwrapOptionField("name", name)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getAssociationId: ZIO[Any, AwsError, AssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getAssociationVersion: ZIO[Any, AwsError, AssociationVersion] =
      AwsError.unwrapOptionField("associationVersion", associationVersion)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getLastExecutionDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastExecutionDate", lastExecutionDate)
    def getOverview
        : ZIO[Any, AwsError, zio.aws.ssm.model.AssociationOverview.ReadOnly] =
      AwsError.unwrapOptionField("overview", overview)
    def getScheduleExpression: ZIO[Any, AwsError, ScheduleExpression] =
      AwsError.unwrapOptionField("scheduleExpression", scheduleExpression)
    def getAssociationName: ZIO[Any, AwsError, AssociationName] =
      AwsError.unwrapOptionField("associationName", associationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.Association
  ) extends zio.aws.ssm.model.Association.ReadOnly {
    override val name: Option[DocumentARN] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.DocumentARN(value))
    override val instanceId: Option[InstanceId] = scala
      .Option(impl.instanceId())
      .map(value => zio.aws.ssm.model.primitives.InstanceId(value))
    override val associationId: Option[AssociationId] = scala
      .Option(impl.associationId())
      .map(value => zio.aws.ssm.model.primitives.AssociationId(value))
    override val associationVersion: Option[AssociationVersion] = scala
      .Option(impl.associationVersion())
      .map(value => zio.aws.ssm.model.primitives.AssociationVersion(value))
    override val documentVersion: Option[DocumentVersion] = scala
      .Option(impl.documentVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]] =
      scala
        .Option(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val lastExecutionDate: Option[DateTime] = scala
      .Option(impl.lastExecutionDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val overview
        : Option[zio.aws.ssm.model.AssociationOverview.ReadOnly] = scala
      .Option(impl.overview())
      .map(value => zio.aws.ssm.model.AssociationOverview.wrap(value))
    override val scheduleExpression: Option[ScheduleExpression] = scala
      .Option(impl.scheduleExpression())
      .map(value => zio.aws.ssm.model.primitives.ScheduleExpression(value))
    override val associationName: Option[AssociationName] = scala
      .Option(impl.associationName())
      .map(value => zio.aws.ssm.model.primitives.AssociationName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.Association
  ): zio.aws.ssm.model.Association.ReadOnly = new Wrapper(impl)
}
