package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait ResourceDataSyncS3Format {
  def unwrap: software.amazon.awssdk.services.ssm.model.ResourceDataSyncS3Format
}
object ResourceDataSyncS3Format {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.ResourceDataSyncS3Format
  ): zio.aws.ssm.model.ResourceDataSyncS3Format = value match {
    case software.amazon.awssdk.services.ssm.model.ResourceDataSyncS3Format.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.ResourceDataSyncS3Format.JSON_SER_DE =>
      val r = JsonSerDe
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.ResourceDataSyncS3Format {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ResourceDataSyncS3Format =
      software.amazon.awssdk.services.ssm.model.ResourceDataSyncS3Format.UNKNOWN_TO_SDK_VERSION
  }
  case object JsonSerDe extends zio.aws.ssm.model.ResourceDataSyncS3Format {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ResourceDataSyncS3Format =
      software.amazon.awssdk.services.ssm.model.ResourceDataSyncS3Format.JSON_SER_DE
  }
}
