package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OpsItemIdentity(arn: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.OpsItemIdentity = {
    import OpsItemIdentity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.OpsItemIdentity
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.OpsItemIdentity.ReadOnly =
    zio.aws.ssm.model.OpsItemIdentity.wrap(buildAwsValue())
}
object OpsItemIdentity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.OpsItemIdentity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.OpsItemIdentity =
      zio.aws.ssm.model.OpsItemIdentity(arn.map(value => value))
    def arn: Option[String]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.OpsItemIdentity
  ) extends zio.aws.ssm.model.OpsItemIdentity.ReadOnly {
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.OpsItemIdentity
  ): zio.aws.ssm.model.OpsItemIdentity.ReadOnly = new Wrapper(impl)
}
