package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  DateTime,
  MaintenanceWindowExecutionStatusDetails,
  MaintenanceWindowExecutionId,
  MaintenanceWindowId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class MaintenanceWindowExecution(
    windowId: Option[MaintenanceWindowId] = None,
    windowExecutionId: Option[MaintenanceWindowExecutionId] = None,
    status: Option[zio.aws.ssm.model.MaintenanceWindowExecutionStatus] = None,
    statusDetails: Option[MaintenanceWindowExecutionStatusDetails] = None,
    startTime: Option[DateTime] = None,
    endTime: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecution = {
    import MaintenanceWindowExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecution
      .builder()
      .optionallyWith(
        windowId.map(value =>
          MaintenanceWindowId.unwrap(value): java.lang.String
        )
      )(_.windowId)
      .optionallyWith(
        windowExecutionId.map(value =>
          MaintenanceWindowExecutionId.unwrap(value): java.lang.String
        )
      )(_.windowExecutionId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusDetails.map(value =>
          MaintenanceWindowExecutionStatusDetails.unwrap(
            value
          ): java.lang.String
        )
      )(_.statusDetails)
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => DateTime.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.MaintenanceWindowExecution.ReadOnly =
    zio.aws.ssm.model.MaintenanceWindowExecution.wrap(buildAwsValue())
}
object MaintenanceWindowExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.MaintenanceWindowExecution =
      zio.aws.ssm.model.MaintenanceWindowExecution(
        windowId.map(value => value),
        windowExecutionId.map(value => value),
        status.map(value => value),
        statusDetails.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def windowId: Option[MaintenanceWindowId]
    def windowExecutionId: Option[MaintenanceWindowExecutionId]
    def status: Option[zio.aws.ssm.model.MaintenanceWindowExecutionStatus]
    def statusDetails: Option[MaintenanceWindowExecutionStatusDetails]
    def startTime: Option[DateTime]
    def endTime: Option[DateTime]
    def getWindowId: ZIO[Any, AwsError, MaintenanceWindowId] =
      AwsError.unwrapOptionField("windowId", windowId)
    def getWindowExecutionId: ZIO[Any, AwsError, MaintenanceWindowExecutionId] =
      AwsError.unwrapOptionField("windowExecutionId", windowExecutionId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusDetails
        : ZIO[Any, AwsError, MaintenanceWindowExecutionStatusDetails] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecution
  ) extends zio.aws.ssm.model.MaintenanceWindowExecution.ReadOnly {
    override val windowId: Option[MaintenanceWindowId] = scala
      .Option(impl.windowId())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowId(value))
    override val windowExecutionId: Option[MaintenanceWindowExecutionId] = scala
      .Option(impl.windowExecutionId())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowExecutionId(value)
      )
    override val status
        : Option[zio.aws.ssm.model.MaintenanceWindowExecutionStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.ssm.model.MaintenanceWindowExecutionStatus.wrap(value)
      )
    override val statusDetails
        : Option[MaintenanceWindowExecutionStatusDetails] = scala
      .Option(impl.statusDetails())
      .map(value =>
        zio.aws.ssm.model.primitives
          .MaintenanceWindowExecutionStatusDetails(value)
      )
    override val startTime: Option[DateTime] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val endTime: Option[DateTime] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecution
  ): zio.aws.ssm.model.MaintenanceWindowExecution.ReadOnly = new Wrapper(impl)
}
