package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{MaxResults, NextToken}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListComplianceSummariesRequest(
    filters: Option[Iterable[zio.aws.ssm.model.ComplianceStringFilter]] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest = {
    import ListComplianceSummariesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListComplianceSummariesRequest.ReadOnly =
    zio.aws.ssm.model.ListComplianceSummariesRequest.wrap(buildAwsValue())
}
object ListComplianceSummariesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListComplianceSummariesRequest =
      zio.aws.ssm.model.ListComplianceSummariesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Option[List[zio.aws.ssm.model.ComplianceStringFilter.ReadOnly]]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.ComplianceStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest
  ) extends zio.aws.ssm.model.ListComplianceSummariesRequest.ReadOnly {
    override val filters
        : Option[List[zio.aws.ssm.model.ComplianceStringFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.ComplianceStringFilter.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest
  ): zio.aws.ssm.model.ListComplianceSummariesRequest.ReadOnly = new Wrapper(
    impl
  )
}
