package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  InstanceInformationFilterValue,
  InstanceInformationStringFilterKey
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InstanceInformationStringFilter(
    key: InstanceInformationStringFilterKey,
    values: Iterable[InstanceInformationFilterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InstanceInformationStringFilter = {
    import InstanceInformationStringFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InstanceInformationStringFilter
      .builder()
      .key(InstanceInformationStringFilterKey.unwrap(key): java.lang.String)
      .values(values.map { item =>
        InstanceInformationFilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InstanceInformationStringFilter.ReadOnly =
    zio.aws.ssm.model.InstanceInformationStringFilter.wrap(buildAwsValue())
}
object InstanceInformationStringFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InstanceInformationStringFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InstanceInformationStringFilter =
      zio.aws.ssm.model.InstanceInformationStringFilter(key, values)
    def key: InstanceInformationStringFilterKey
    def values: List[InstanceInformationFilterValue]
    def getKey: ZIO[Any, Nothing, InstanceInformationStringFilterKey] =
      ZIO.succeed(key)
    def getValues: ZIO[Any, Nothing, List[InstanceInformationFilterValue]] =
      ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InstanceInformationStringFilter
  ) extends zio.aws.ssm.model.InstanceInformationStringFilter.ReadOnly {
    override val key: InstanceInformationStringFilterKey =
      zio.aws.ssm.model.primitives
        .InstanceInformationStringFilterKey(impl.key())
    override val values: List[InstanceInformationFilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.InstanceInformationFilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InstanceInformationStringFilter
  ): zio.aws.ssm.model.InstanceInformationStringFilter.ReadOnly = new Wrapper(
    impl
  )
}
