package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait ExecutionMode {
  def unwrap: software.amazon.awssdk.services.ssm.model.ExecutionMode
}
object ExecutionMode {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.ExecutionMode
  ): zio.aws.ssm.model.ExecutionMode = value match {
    case software.amazon.awssdk.services.ssm.model.ExecutionMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.ExecutionMode.AUTO =>
      val r = Auto
      r
    case software.amazon.awssdk.services.ssm.model.ExecutionMode.INTERACTIVE =>
      val r = Interactive
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.ExecutionMode {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ExecutionMode =
      software.amazon.awssdk.services.ssm.model.ExecutionMode.UNKNOWN_TO_SDK_VERSION
  }
  case object Auto extends zio.aws.ssm.model.ExecutionMode {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ExecutionMode =
      software.amazon.awssdk.services.ssm.model.ExecutionMode.AUTO
  }
  case object Interactive extends zio.aws.ssm.model.ExecutionMode {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ExecutionMode =
      software.amazon.awssdk.services.ssm.model.ExecutionMode.INTERACTIVE
  }
}
