package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  DocumentHash,
  DocumentDisplayName,
  DocumentSha1,
  DocumentARN,
  DocumentVersion,
  DateTime,
  DescriptionInDocument,
  DocumentSchemaVersion,
  DocumentAuthor,
  DocumentOwner,
  Category,
  DocumentStatusInformation,
  DocumentVersionName,
  TargetType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DocumentDescription(
    sha1: Option[DocumentSha1] = None,
    hash: Option[DocumentHash] = None,
    hashType: Option[zio.aws.ssm.model.DocumentHashType] = None,
    name: Option[DocumentARN] = None,
    displayName: Option[DocumentDisplayName] = None,
    versionName: Option[DocumentVersionName] = None,
    owner: Option[DocumentOwner] = None,
    createdDate: Option[DateTime] = None,
    status: Option[zio.aws.ssm.model.DocumentStatus] = None,
    statusInformation: Option[DocumentStatusInformation] = None,
    documentVersion: Option[DocumentVersion] = None,
    description: Option[DescriptionInDocument] = None,
    parameters: Option[Iterable[zio.aws.ssm.model.DocumentParameter]] = None,
    platformTypes: Option[Iterable[zio.aws.ssm.model.PlatformType]] = None,
    documentType: Option[zio.aws.ssm.model.DocumentType] = None,
    schemaVersion: Option[DocumentSchemaVersion] = None,
    latestVersion: Option[DocumentVersion] = None,
    defaultVersion: Option[DocumentVersion] = None,
    documentFormat: Option[zio.aws.ssm.model.DocumentFormat] = None,
    targetType: Option[TargetType] = None,
    tags: Option[Iterable[zio.aws.ssm.model.Tag]] = None,
    attachmentsInformation: Option[
      Iterable[zio.aws.ssm.model.AttachmentInformation]
    ] = None,
    requires: Option[Iterable[zio.aws.ssm.model.DocumentRequires]] = None,
    author: Option[DocumentAuthor] = None,
    reviewInformation: Option[Iterable[zio.aws.ssm.model.ReviewInformation]] =
      None,
    approvedVersion: Option[DocumentVersion] = None,
    pendingReviewVersion: Option[DocumentVersion] = None,
    reviewStatus: Option[zio.aws.ssm.model.ReviewStatus] = None,
    category: Option[Iterable[Category]] = None,
    categoryEnum: Option[Iterable[Category]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DocumentDescription = {
    import DocumentDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DocumentDescription
      .builder()
      .optionallyWith(
        sha1.map(value => DocumentSha1.unwrap(value): java.lang.String)
      )(_.sha1)
      .optionallyWith(
        hash.map(value => DocumentHash.unwrap(value): java.lang.String)
      )(_.hash)
      .optionallyWith(hashType.map(value => value.unwrap))(_.hashType)
      .optionallyWith(
        name.map(value => DocumentARN.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        displayName.map(value =>
          DocumentDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        versionName.map(value =>
          DocumentVersionName.unwrap(value): java.lang.String
        )
      )(_.versionName)
      .optionallyWith(
        owner.map(value => DocumentOwner.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        createdDate.map(value => DateTime.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusInformation.map(value =>
          DocumentStatusInformation.unwrap(value): java.lang.String
        )
      )(_.statusInformation)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        description.map(value =>
          DescriptionInDocument.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        platformTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.platformTypesWithStrings)
      .optionallyWith(documentType.map(value => value.unwrap))(_.documentType)
      .optionallyWith(
        schemaVersion.map(value =>
          DocumentSchemaVersion.unwrap(value): java.lang.String
        )
      )(_.schemaVersion)
      .optionallyWith(
        latestVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.latestVersion)
      .optionallyWith(
        defaultVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.defaultVersion)
      .optionallyWith(documentFormat.map(value => value.unwrap))(
        _.documentFormat
      )
      .optionallyWith(
        targetType.map(value => TargetType.unwrap(value): java.lang.String)
      )(_.targetType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        attachmentsInformation.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachmentsInformation)
      .optionallyWith(
        requires.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.requires)
      .optionallyWith(
        author.map(value => DocumentAuthor.unwrap(value): java.lang.String)
      )(_.author)
      .optionallyWith(
        reviewInformation.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reviewInformation)
      .optionallyWith(
        approvedVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.approvedVersion)
      .optionallyWith(
        pendingReviewVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.pendingReviewVersion)
      .optionallyWith(reviewStatus.map(value => value.unwrap))(_.reviewStatus)
      .optionallyWith(
        category.map(value =>
          value.map { item =>
            Category.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.category)
      .optionallyWith(
        categoryEnum.map(value =>
          value.map { item =>
            Category.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.categoryEnum)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DocumentDescription.ReadOnly =
    zio.aws.ssm.model.DocumentDescription.wrap(buildAwsValue())
}
object DocumentDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DocumentDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DocumentDescription =
      zio.aws.ssm.model.DocumentDescription(
        sha1.map(value => value),
        hash.map(value => value),
        hashType.map(value => value),
        name.map(value => value),
        displayName.map(value => value),
        versionName.map(value => value),
        owner.map(value => value),
        createdDate.map(value => value),
        status.map(value => value),
        statusInformation.map(value => value),
        documentVersion.map(value => value),
        description.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        platformTypes.map(value => value),
        documentType.map(value => value),
        schemaVersion.map(value => value),
        latestVersion.map(value => value),
        defaultVersion.map(value => value),
        documentFormat.map(value => value),
        targetType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        attachmentsInformation.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        requires.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        author.map(value => value),
        reviewInformation.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        approvedVersion.map(value => value),
        pendingReviewVersion.map(value => value),
        reviewStatus.map(value => value),
        category.map(value => value),
        categoryEnum.map(value => value)
      )
    def sha1: Option[DocumentSha1]
    def hash: Option[DocumentHash]
    def hashType: Option[zio.aws.ssm.model.DocumentHashType]
    def name: Option[DocumentARN]
    def displayName: Option[DocumentDisplayName]
    def versionName: Option[DocumentVersionName]
    def owner: Option[DocumentOwner]
    def createdDate: Option[DateTime]
    def status: Option[zio.aws.ssm.model.DocumentStatus]
    def statusInformation: Option[DocumentStatusInformation]
    def documentVersion: Option[DocumentVersion]
    def description: Option[DescriptionInDocument]
    def parameters: Option[List[zio.aws.ssm.model.DocumentParameter.ReadOnly]]
    def platformTypes: Option[List[zio.aws.ssm.model.PlatformType]]
    def documentType: Option[zio.aws.ssm.model.DocumentType]
    def schemaVersion: Option[DocumentSchemaVersion]
    def latestVersion: Option[DocumentVersion]
    def defaultVersion: Option[DocumentVersion]
    def documentFormat: Option[zio.aws.ssm.model.DocumentFormat]
    def targetType: Option[TargetType]
    def tags: Option[List[zio.aws.ssm.model.Tag.ReadOnly]]
    def attachmentsInformation
        : Option[List[zio.aws.ssm.model.AttachmentInformation.ReadOnly]]
    def requires: Option[List[zio.aws.ssm.model.DocumentRequires.ReadOnly]]
    def author: Option[DocumentAuthor]
    def reviewInformation
        : Option[List[zio.aws.ssm.model.ReviewInformation.ReadOnly]]
    def approvedVersion: Option[DocumentVersion]
    def pendingReviewVersion: Option[DocumentVersion]
    def reviewStatus: Option[zio.aws.ssm.model.ReviewStatus]
    def category: Option[List[Category]]
    def categoryEnum: Option[List[Category]]
    def getSha1: ZIO[Any, AwsError, DocumentSha1] =
      AwsError.unwrapOptionField("sha1", sha1)
    def getHash: ZIO[Any, AwsError, DocumentHash] =
      AwsError.unwrapOptionField("hash", hash)
    def getHashType: ZIO[Any, AwsError, zio.aws.ssm.model.DocumentHashType] =
      AwsError.unwrapOptionField("hashType", hashType)
    def getName: ZIO[Any, AwsError, DocumentARN] =
      AwsError.unwrapOptionField("name", name)
    def getDisplayName: ZIO[Any, AwsError, DocumentDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getVersionName: ZIO[Any, AwsError, DocumentVersionName] =
      AwsError.unwrapOptionField("versionName", versionName)
    def getOwner: ZIO[Any, AwsError, DocumentOwner] =
      AwsError.unwrapOptionField("owner", owner)
    def getCreatedDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssm.model.DocumentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusInformation: ZIO[Any, AwsError, DocumentStatusInformation] =
      AwsError.unwrapOptionField("statusInformation", statusInformation)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getDescription: ZIO[Any, AwsError, DescriptionInDocument] =
      AwsError.unwrapOptionField("description", description)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.DocumentParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getPlatformTypes
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.PlatformType]] =
      AwsError.unwrapOptionField("platformTypes", platformTypes)
    def getDocumentType: ZIO[Any, AwsError, zio.aws.ssm.model.DocumentType] =
      AwsError.unwrapOptionField("documentType", documentType)
    def getSchemaVersion: ZIO[Any, AwsError, DocumentSchemaVersion] =
      AwsError.unwrapOptionField("schemaVersion", schemaVersion)
    def getLatestVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("latestVersion", latestVersion)
    def getDefaultVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("defaultVersion", defaultVersion)
    def getDocumentFormat
        : ZIO[Any, AwsError, zio.aws.ssm.model.DocumentFormat] =
      AwsError.unwrapOptionField("documentFormat", documentFormat)
    def getTargetType: ZIO[Any, AwsError, TargetType] =
      AwsError.unwrapOptionField("targetType", targetType)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ssm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAttachmentsInformation: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.AttachmentInformation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "attachmentsInformation",
      attachmentsInformation
    )
    def getRequires: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.DocumentRequires.ReadOnly
    ]] = AwsError.unwrapOptionField("requires", requires)
    def getAuthor: ZIO[Any, AwsError, DocumentAuthor] =
      AwsError.unwrapOptionField("author", author)
    def getReviewInformation: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.ReviewInformation.ReadOnly
    ]] = AwsError.unwrapOptionField("reviewInformation", reviewInformation)
    def getApprovedVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("approvedVersion", approvedVersion)
    def getPendingReviewVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("pendingReviewVersion", pendingReviewVersion)
    def getReviewStatus: ZIO[Any, AwsError, zio.aws.ssm.model.ReviewStatus] =
      AwsError.unwrapOptionField("reviewStatus", reviewStatus)
    def getCategory: ZIO[Any, AwsError, List[Category]] =
      AwsError.unwrapOptionField("category", category)
    def getCategoryEnum: ZIO[Any, AwsError, List[Category]] =
      AwsError.unwrapOptionField("categoryEnum", categoryEnum)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DocumentDescription
  ) extends zio.aws.ssm.model.DocumentDescription.ReadOnly {
    override val sha1: Option[DocumentSha1] = scala
      .Option(impl.sha1())
      .map(value => zio.aws.ssm.model.primitives.DocumentSha1(value))
    override val hash: Option[DocumentHash] = scala
      .Option(impl.hash())
      .map(value => zio.aws.ssm.model.primitives.DocumentHash(value))
    override val hashType: Option[zio.aws.ssm.model.DocumentHashType] = scala
      .Option(impl.hashType())
      .map(value => zio.aws.ssm.model.DocumentHashType.wrap(value))
    override val name: Option[DocumentARN] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.DocumentARN(value))
    override val displayName: Option[DocumentDisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.ssm.model.primitives.DocumentDisplayName(value))
    override val versionName: Option[DocumentVersionName] = scala
      .Option(impl.versionName())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersionName(value))
    override val owner: Option[DocumentOwner] = scala
      .Option(impl.owner())
      .map(value => zio.aws.ssm.model.primitives.DocumentOwner(value))
    override val createdDate: Option[DateTime] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val status: Option[zio.aws.ssm.model.DocumentStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.ssm.model.DocumentStatus.wrap(value))
    override val statusInformation: Option[DocumentStatusInformation] = scala
      .Option(impl.statusInformation())
      .map(value =>
        zio.aws.ssm.model.primitives.DocumentStatusInformation(value)
      )
    override val documentVersion: Option[DocumentVersion] = scala
      .Option(impl.documentVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val description: Option[DescriptionInDocument] = scala
      .Option(impl.description())
      .map(value => zio.aws.ssm.model.primitives.DescriptionInDocument(value))
    override val parameters
        : Option[List[zio.aws.ssm.model.DocumentParameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.DocumentParameter.wrap(item)
        }.toList
      )
    override val platformTypes: Option[List[zio.aws.ssm.model.PlatformType]] =
      scala
        .Option(impl.platformTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.PlatformType.wrap(item)
          }.toList
        )
    override val documentType: Option[zio.aws.ssm.model.DocumentType] = scala
      .Option(impl.documentType())
      .map(value => zio.aws.ssm.model.DocumentType.wrap(value))
    override val schemaVersion: Option[DocumentSchemaVersion] = scala
      .Option(impl.schemaVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentSchemaVersion(value))
    override val latestVersion: Option[DocumentVersion] = scala
      .Option(impl.latestVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val defaultVersion: Option[DocumentVersion] = scala
      .Option(impl.defaultVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val documentFormat: Option[zio.aws.ssm.model.DocumentFormat] =
      scala
        .Option(impl.documentFormat())
        .map(value => zio.aws.ssm.model.DocumentFormat.wrap(value))
    override val targetType: Option[TargetType] = scala
      .Option(impl.targetType())
      .map(value => zio.aws.ssm.model.primitives.TargetType(value))
    override val tags: Option[List[zio.aws.ssm.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.Tag.wrap(item)
        }.toList
      )
    override val attachmentsInformation
        : Option[List[zio.aws.ssm.model.AttachmentInformation.ReadOnly]] = scala
      .Option(impl.attachmentsInformation())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.AttachmentInformation.wrap(item)
        }.toList
      )
    override val requires
        : Option[List[zio.aws.ssm.model.DocumentRequires.ReadOnly]] = scala
      .Option(impl.requires())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.DocumentRequires.wrap(item)
        }.toList
      )
    override val author: Option[DocumentAuthor] = scala
      .Option(impl.author())
      .map(value => zio.aws.ssm.model.primitives.DocumentAuthor(value))
    override val reviewInformation
        : Option[List[zio.aws.ssm.model.ReviewInformation.ReadOnly]] = scala
      .Option(impl.reviewInformation())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.ReviewInformation.wrap(item)
        }.toList
      )
    override val approvedVersion: Option[DocumentVersion] = scala
      .Option(impl.approvedVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val pendingReviewVersion: Option[DocumentVersion] = scala
      .Option(impl.pendingReviewVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val reviewStatus: Option[zio.aws.ssm.model.ReviewStatus] = scala
      .Option(impl.reviewStatus())
      .map(value => zio.aws.ssm.model.ReviewStatus.wrap(value))
    override val category: Option[List[Category]] = scala
      .Option(impl.category())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.Category(item)
        }.toList
      )
    override val categoryEnum: Option[List[Category]] = scala
      .Option(impl.categoryEnum())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.Category(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DocumentDescription
  ): zio.aws.ssm.model.DocumentDescription.ReadOnly = new Wrapper(impl)
}
