package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAutomationExecutionsResponse(
    automationExecutionMetadataList: Option[
      Iterable[zio.aws.ssm.model.AutomationExecutionMetadata]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse = {
    import DescribeAutomationExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse
      .builder()
      .optionallyWith(
        automationExecutionMetadataList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.automationExecutionMetadataList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeAutomationExecutionsResponse.ReadOnly =
    zio.aws.ssm.model.DescribeAutomationExecutionsResponse.wrap(buildAwsValue())
}
object DescribeAutomationExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeAutomationExecutionsResponse =
      zio.aws.ssm.model.DescribeAutomationExecutionsResponse(
        automationExecutionMetadataList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def automationExecutionMetadataList
        : Option[List[zio.aws.ssm.model.AutomationExecutionMetadata.ReadOnly]]
    def nextToken: Option[NextToken]
    def getAutomationExecutionMetadataList: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.AutomationExecutionMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "automationExecutionMetadataList",
      automationExecutionMetadataList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse
  ) extends zio.aws.ssm.model.DescribeAutomationExecutionsResponse.ReadOnly {
    override val automationExecutionMetadataList
        : Option[List[zio.aws.ssm.model.AutomationExecutionMetadata.ReadOnly]] =
      scala
        .Option(impl.automationExecutionMetadataList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.AutomationExecutionMetadata.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse
  ): zio.aws.ssm.model.DescribeAutomationExecutionsResponse.ReadOnly =
    new Wrapper(impl)
}
