package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{PatchGroup, BaselineId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeregisterPatchBaselineForPatchGroupRequest(
    baselineId: BaselineId,
    patchGroup: PatchGroup
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupRequest = {
    import DeregisterPatchBaselineForPatchGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupRequest
      .builder()
      .baselineId(BaselineId.unwrap(baselineId): java.lang.String)
      .patchGroup(PatchGroup.unwrap(patchGroup): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DeregisterPatchBaselineForPatchGroupRequest.ReadOnly =
    zio.aws.ssm.model.DeregisterPatchBaselineForPatchGroupRequest
      .wrap(buildAwsValue())
}
object DeregisterPatchBaselineForPatchGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DeregisterPatchBaselineForPatchGroupRequest =
      zio.aws.ssm.model
        .DeregisterPatchBaselineForPatchGroupRequest(baselineId, patchGroup)
    def baselineId: BaselineId
    def patchGroup: PatchGroup
    def getBaselineId: ZIO[Any, Nothing, BaselineId] = ZIO.succeed(baselineId)
    def getPatchGroup: ZIO[Any, Nothing, PatchGroup] = ZIO.succeed(patchGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupRequest
  ) extends zio.aws.ssm.model.DeregisterPatchBaselineForPatchGroupRequest.ReadOnly {
    override val baselineId: BaselineId =
      zio.aws.ssm.model.primitives.BaselineId(impl.baselineId())
    override val patchGroup: PatchGroup =
      zio.aws.ssm.model.primitives.PatchGroup(impl.patchGroup())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupRequest
  ): zio.aws.ssm.model.DeregisterPatchBaselineForPatchGroupRequest.ReadOnly =
    new Wrapper(impl)
}
