package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.ComplianceSummaryCount
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SeveritySummary(
    criticalCount: Option[ComplianceSummaryCount] = None,
    highCount: Option[ComplianceSummaryCount] = None,
    mediumCount: Option[ComplianceSummaryCount] = None,
    lowCount: Option[ComplianceSummaryCount] = None,
    informationalCount: Option[ComplianceSummaryCount] = None,
    unspecifiedCount: Option[ComplianceSummaryCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.SeveritySummary = {
    import SeveritySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.SeveritySummary
      .builder()
      .optionallyWith(
        criticalCount.map(value =>
          ComplianceSummaryCount.unwrap(value): Integer
        )
      )(_.criticalCount)
      .optionallyWith(
        highCount.map(value => ComplianceSummaryCount.unwrap(value): Integer)
      )(_.highCount)
      .optionallyWith(
        mediumCount.map(value => ComplianceSummaryCount.unwrap(value): Integer)
      )(_.mediumCount)
      .optionallyWith(
        lowCount.map(value => ComplianceSummaryCount.unwrap(value): Integer)
      )(_.lowCount)
      .optionallyWith(
        informationalCount.map(value =>
          ComplianceSummaryCount.unwrap(value): Integer
        )
      )(_.informationalCount)
      .optionallyWith(
        unspecifiedCount.map(value =>
          ComplianceSummaryCount.unwrap(value): Integer
        )
      )(_.unspecifiedCount)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.SeveritySummary.ReadOnly =
    zio.aws.ssm.model.SeveritySummary.wrap(buildAwsValue())
}
object SeveritySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.SeveritySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.SeveritySummary =
      zio.aws.ssm.model.SeveritySummary(
        criticalCount.map(value => value),
        highCount.map(value => value),
        mediumCount.map(value => value),
        lowCount.map(value => value),
        informationalCount.map(value => value),
        unspecifiedCount.map(value => value)
      )
    def criticalCount: Option[ComplianceSummaryCount]
    def highCount: Option[ComplianceSummaryCount]
    def mediumCount: Option[ComplianceSummaryCount]
    def lowCount: Option[ComplianceSummaryCount]
    def informationalCount: Option[ComplianceSummaryCount]
    def unspecifiedCount: Option[ComplianceSummaryCount]
    def getCriticalCount: ZIO[Any, AwsError, ComplianceSummaryCount] =
      AwsError.unwrapOptionField("criticalCount", criticalCount)
    def getHighCount: ZIO[Any, AwsError, ComplianceSummaryCount] =
      AwsError.unwrapOptionField("highCount", highCount)
    def getMediumCount: ZIO[Any, AwsError, ComplianceSummaryCount] =
      AwsError.unwrapOptionField("mediumCount", mediumCount)
    def getLowCount: ZIO[Any, AwsError, ComplianceSummaryCount] =
      AwsError.unwrapOptionField("lowCount", lowCount)
    def getInformationalCount: ZIO[Any, AwsError, ComplianceSummaryCount] =
      AwsError.unwrapOptionField("informationalCount", informationalCount)
    def getUnspecifiedCount: ZIO[Any, AwsError, ComplianceSummaryCount] =
      AwsError.unwrapOptionField("unspecifiedCount", unspecifiedCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.SeveritySummary
  ) extends zio.aws.ssm.model.SeveritySummary.ReadOnly {
    override val criticalCount: Option[ComplianceSummaryCount] = scala
      .Option(impl.criticalCount())
      .map(value => zio.aws.ssm.model.primitives.ComplianceSummaryCount(value))
    override val highCount: Option[ComplianceSummaryCount] = scala
      .Option(impl.highCount())
      .map(value => zio.aws.ssm.model.primitives.ComplianceSummaryCount(value))
    override val mediumCount: Option[ComplianceSummaryCount] = scala
      .Option(impl.mediumCount())
      .map(value => zio.aws.ssm.model.primitives.ComplianceSummaryCount(value))
    override val lowCount: Option[ComplianceSummaryCount] = scala
      .Option(impl.lowCount())
      .map(value => zio.aws.ssm.model.primitives.ComplianceSummaryCount(value))
    override val informationalCount: Option[ComplianceSummaryCount] = scala
      .Option(impl.informationalCount())
      .map(value => zio.aws.ssm.model.primitives.ComplianceSummaryCount(value))
    override val unspecifiedCount: Option[ComplianceSummaryCount] = scala
      .Option(impl.unspecifiedCount())
      .map(value => zio.aws.ssm.model.primitives.ComplianceSummaryCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.SeveritySummary
  ): zio.aws.ssm.model.SeveritySummary.ReadOnly = new Wrapper(impl)
}
