package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  AttributeName,
  InventoryItemSchemaVersion,
  InventoryItemCaptureTime,
  InventoryItemTypeName,
  InventoryItemContentHash,
  AttributeValue
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InventoryItem(
    typeName: InventoryItemTypeName,
    schemaVersion: InventoryItemSchemaVersion,
    captureTime: InventoryItemCaptureTime,
    contentHash: Option[InventoryItemContentHash] = None,
    content: Option[Iterable[Map[AttributeName, AttributeValue]]] = None,
    context: Option[Map[AttributeName, AttributeValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InventoryItem = {
    import InventoryItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InventoryItem
      .builder()
      .typeName(InventoryItemTypeName.unwrap(typeName): java.lang.String)
      .schemaVersion(
        InventoryItemSchemaVersion.unwrap(schemaVersion): java.lang.String
      )
      .captureTime(
        InventoryItemCaptureTime.unwrap(captureTime): java.lang.String
      )
      .optionallyWith(
        contentHash.map(value =>
          InventoryItemContentHash.unwrap(value): java.lang.String
        )
      )(_.contentHash)
      .optionallyWith(
        content.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                  .unwrap(value): java.lang.String)
              })
              .asJava
          }.asJavaCollection
        )
      )(_.content)
      .optionallyWith(
        context.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.context)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InventoryItem.ReadOnly =
    zio.aws.ssm.model.InventoryItem.wrap(buildAwsValue())
}
object InventoryItem {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.InventoryItem] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InventoryItem =
      zio.aws.ssm.model.InventoryItem(
        typeName,
        schemaVersion,
        captureTime,
        contentHash.map(value => value),
        content.map(value => value),
        context.map(value => value)
      )
    def typeName: InventoryItemTypeName
    def schemaVersion: InventoryItemSchemaVersion
    def captureTime: InventoryItemCaptureTime
    def contentHash: Option[InventoryItemContentHash]
    def content: Option[List[Map[AttributeName, AttributeValue]]]
    def context: Option[Map[AttributeName, AttributeValue]]
    def getTypeName: ZIO[Any, Nothing, InventoryItemTypeName] =
      ZIO.succeed(typeName)
    def getSchemaVersion: ZIO[Any, Nothing, InventoryItemSchemaVersion] =
      ZIO.succeed(schemaVersion)
    def getCaptureTime: ZIO[Any, Nothing, InventoryItemCaptureTime] =
      ZIO.succeed(captureTime)
    def getContentHash: ZIO[Any, AwsError, InventoryItemContentHash] =
      AwsError.unwrapOptionField("contentHash", contentHash)
    def getContent
        : ZIO[Any, AwsError, List[Map[AttributeName, AttributeValue]]] =
      AwsError.unwrapOptionField("content", content)
    def getContext: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("context", context)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InventoryItem
  ) extends zio.aws.ssm.model.InventoryItem.ReadOnly {
    override val typeName: InventoryItemTypeName =
      zio.aws.ssm.model.primitives.InventoryItemTypeName(impl.typeName())
    override val schemaVersion: InventoryItemSchemaVersion =
      zio.aws.ssm.model.primitives
        .InventoryItemSchemaVersion(impl.schemaVersion())
    override val captureTime: InventoryItemCaptureTime =
      zio.aws.ssm.model.primitives.InventoryItemCaptureTime(impl.captureTime())
    override val contentHash: Option[InventoryItemContentHash] = scala
      .Option(impl.contentHash())
      .map(value =>
        zio.aws.ssm.model.primitives.InventoryItemContentHash(value)
      )
    override val content: Option[List[Map[AttributeName, AttributeValue]]] =
      scala
        .Option(impl.content())
        .map(value =>
          value.asScala.map { item =>
            item.asScala
              .map({ case (key, value) =>
                zio.aws.ssm.model.primitives.AttributeName(
                  key
                ) -> zio.aws.ssm.model.primitives.AttributeValue(value)
              })
              .toMap
          }.toList
        )
    override val context: Option[Map[AttributeName, AttributeValue]] = scala
      .Option(impl.context())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives.AttributeName(
              key
            ) -> zio.aws.ssm.model.primitives.AttributeValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InventoryItem
  ): zio.aws.ssm.model.InventoryItem.ReadOnly = new Wrapper(impl)
}
